/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.maven.model;

import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.plugins.api.maven.MavenTestCase;
import org.sonar.plugins.api.maven.model.MavenPlugin;
import org.sonar.plugins.api.maven.model.MavenPom;

public class MavenPluginTest
extends MavenTestCase {
    private static final String GROUP_ID = "foo";
    private static final String ARTIFACT_ID = "bar";
    private static final String VERSION = "baz";
    private static final String TYPE = "jar";

    @Test
    public void testCopyPluginDependencies() {
        MavenPom pom = this.readMavenProject("/org/sonar/plugins/api/maven/model/MavenPluginDependencies.xml");
        MavenPlugin depsToCopyIn = new MavenPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
        MavenPluginTest.assertDependenciesSize(depsToCopyIn, 0);
        depsToCopyIn.copyDependenciesFrom(pom);
        MavenPluginTest.assertDependenciesSize(depsToCopyIn, 1);
        MavenPluginTest.assertDependency(MavenPluginTest.getFirstPluginDependency(depsToCopyIn));
    }

    private static Dependency getFirstPluginDependency(MavenPlugin depsToCopyIn) {
        return (Dependency)depsToCopyIn.getMavenPlugin().getDependencies().get(0);
    }

    private static void assertDependenciesSize(MavenPlugin plugin, int size) {
        Assert.assertThat((Object)plugin.getMavenPlugin().getDependencies().size(), (Matcher)Matchers.is((Object)size));
    }

    @Test
    public void shouldAddDependency() {
        MavenPlugin mavenPlugin = MavenPluginTest.createSimplePlugin();
        mavenPlugin.addDependency(GROUP_ID, ARTIFACT_ID, VERSION, TYPE);
        MavenPluginTest.assertDependenciesSize(mavenPlugin, 1);
        MavenPluginTest.assertDependency(MavenPluginTest.getFirstPluginDependency(mavenPlugin));
    }

    private static MavenPlugin createSimplePlugin() {
        return new MavenPlugin(new Plugin());
    }

    private static void assertDependency(Dependency dependency) {
        Assert.assertThat((Object)dependency.getGroupId(), (Matcher)Matchers.is((Object)GROUP_ID));
        Assert.assertThat((Object)dependency.getArtifactId(), (Matcher)Matchers.is((Object)ARTIFACT_ID));
        Assert.assertThat((Object)dependency.getVersion(), (Matcher)Matchers.is((Object)VERSION));
        Assert.assertThat((Object)dependency.getType(), (Matcher)Matchers.is((Object)TYPE));
    }

    @Test
    public void shouldBeEqual() {
        MavenPlugin plugin = new MavenPlugin(GROUP_ID, ARTIFACT_ID);
        Assert.assertThat((String)"Plugin should be equal.", (Object)plugin.isEqual(GROUP_ID, ARTIFACT_ID), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldNotBeEqual() {
        MavenPlugin plugin = new MavenPlugin(GROUP_ID, ARTIFACT_ID);
        Assert.assertThat((String)"Plugin should not be equal.", (Object)plugin.isEqual("abc", "def"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldBeEqualWithNullGroupId() {
        MavenPlugin plugin = new MavenPlugin(null, ARTIFACT_ID);
        Assert.assertThat((String)"Plugin should be equal.", (Object)plugin.isEqual(null, ARTIFACT_ID), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldBeEqualWithDefaultMavenGroupId() {
        MavenPlugin plugin = new MavenPlugin(null, ARTIFACT_ID);
        Assert.assertThat((String)"Plugin should be equal.", (Object)plugin.isEqual("org.apache.maven.plugins", ARTIFACT_ID), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldBeEqualWithDefaultCodehausGroupId() {
        MavenPlugin plugin = new MavenPlugin(null, ARTIFACT_ID);
        Assert.assertThat((String)"Plugin should be equal.", (Object)plugin.isEqual("org.codehaus.mojo", ARTIFACT_ID), (Matcher)Matchers.is((Object)true));
    }
}

