/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.maven.model;

import org.apache.commons.configuration.Configuration;
import org.apache.maven.project.MavenProject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.plugins.api.Languages;
import org.sonar.plugins.api.maven.MavenTestCase;
import org.sonar.plugins.api.maven.model.MavenPlugin;
import org.sonar.plugins.api.maven.model.MavenPluginConfiguration;
import org.sonar.plugins.api.maven.model.MavenPom;

public class MavenPomTest
extends MavenTestCase {
    protected MavenPom pom;

    @Before
    public void setUp() {
        this.pom = this.readMavenProject("/org/sonar/plugins/api/maven/model/MavenPom.xml");
    }

    @Test
    public void testFindBuildPlugin() {
        Assert.assertNull((Object)this.pom.getBuildPlugin("foo", "bar"));
        Assert.assertEquals((Object)"0.1.1", (Object)this.pom.getBuildPlugin("ch.hortis.sonar", "sonar-core-maven-plugin").getVersion());
        Assert.assertNotNull((Object)this.pom.getBuildPlugin("org.apache.maven.plugins", "maven-compiler-plugin"));
    }

    @Test
    public void testFindPluginConfigurationFromPluginManagement() {
        MavenPom pom = this.readMavenProject("/org/sonar/plugins/api/maven/model/MavenPomPM.xml");
        MavenPluginConfiguration conf = pom.findPluginConfiguration("org.apache.maven.plugins", "maven-compiler-plugin");
        Assert.assertNotNull((Object)conf);
        Assert.assertEquals((Object)"1.4", (Object)conf.getChildValue("source"));
    }

    @Test
    public void testFindPluginConfigurationFromParent() {
        MavenPom pom = this.readMavenProject("/org/sonar/plugins/api/maven/model/MavenPomEmptyConfig.xml");
        MavenPom parent = this.readMavenProject("/org/sonar/plugins/api/maven/model/MavenPomRoot.xml");
        pom.getMavenProject().setParent(parent.getMavenProject());
        MavenPluginConfiguration conf = pom.findPluginConfiguration("org.apache.maven.plugins", "maven-compiler-plugin");
        Assert.assertNotNull((Object)conf);
        Assert.assertEquals((Object)"1.1", (Object)conf.getChildValue("source"));
    }

    @Test
    public void testGetConfigurationValue() {
        MavenPlugin plugin = this.pom.getBuildPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
        Assert.assertEquals((Object)"1.5", (Object)plugin.getConfigParameter("target"));
        Assert.assertNull((Object)plugin.getConfigParameter("foo"));
    }

    @Test
    public void shouldGetLanguageFromPom() {
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        Mockito.stub((Object)conf.getString("sonar.language")).toReturn((Object)"plsql");
        Assert.assertEquals((Object)Languages.PLSQL, (Object)new MavenPom((MavenProject)Mockito.mock(MavenProject.class), conf).getLanguage());
    }

    @Test
    public void defaultLanguageShouldBeJava() {
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        Mockito.stub((Object)conf.getString("sonar.language")).toReturn(null);
        Assert.assertEquals((Object)Languages.JAVA, (Object)new MavenPom((MavenProject)Mockito.mock(MavenProject.class), conf).getLanguage());
    }
}

