/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.rules;

import ch.hortis.sonar.model.ActiveRule;
import ch.hortis.sonar.model.Rule;
import ch.hortis.sonar.model.RuleFailureLevel;
import ch.hortis.sonar.model.RulesProfile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.commons.rules.ActiveRuleParam;
import org.sonar.commons.rules.RuleParam;
import org.sonar.plugins.api.maven.xml.Profile;
import org.sonar.plugins.api.maven.xml.Property;
import org.sonar.plugins.api.rules.ProfileNameNullException;
import org.sonar.plugins.api.rules.StandardProfileXmlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardProfileXmlParserTest {
    @Test
    public void checkAllFields() {
        StandardProfileXmlParser parser = new StandardProfileXmlParser();
        String xml = "<profile name='Sonar way' language='java'><rule key=\"2006\" severity=\"warning\" /><rule key=\"2007\" severity=\"error\"><property name=\"toto\" value=\"titi\" /></rule></profile>";
        Profile profile = parser.parse(xml);
        Assert.assertEquals((long)2L, (long)profile.getRules().size());
        Assert.assertEquals((Object)"Sonar way", (Object)profile.getName());
        org.sonar.plugins.api.maven.xml.Rule rule1 = (org.sonar.plugins.api.maven.xml.Rule)profile.getRules().get(0);
        Assert.assertEquals((Object)"2006", (Object)rule1.getKey());
        Assert.assertEquals((Object)"warning", (Object)rule1.getSeverity());
        Assert.assertNull((Object)rule1.getProperties());
        org.sonar.plugins.api.maven.xml.Rule rule2 = (org.sonar.plugins.api.maven.xml.Rule)profile.getRules().get(1);
        Assert.assertEquals((Object)"2007", (Object)rule2.getKey());
        Assert.assertEquals((Object)"error", (Object)rule2.getSeverity());
        Assert.assertEquals((long)rule2.getProperties().size(), (long)1L);
        Property property = (Property)rule2.getProperties().get(0);
        Assert.assertEquals((Object)"toto", (Object)property.getName());
        Assert.assertEquals((Object)"titi", (Object)property.getValue());
    }

    @Test(expected=ProfileNameNullException.class)
    public void shouldProfileNameBeNotNull() throws IOException {
        InputStream input = this.getClass().getResourceAsStream("/org/sonar/plugins/api/rules/test_profile_name_null.xml");
        StandardProfileXmlParser standardProfileXmlParser = new StandardProfileXmlParser();
        standardProfileXmlParser.importConfiguration(IOUtils.toString((InputStream)input));
    }

    @Test
    public void shouldBuildProfileFromXml() throws IOException {
        StandardProfileXmlParser standardProfileXmlParser = new StandardProfileXmlParser();
        InputStream input = this.getClass().getResourceAsStream("/org/sonar/plugins/api/rules/test_profile.xml");
        Profile profile = standardProfileXmlParser.buildProfileFromXml(IOUtils.toString((InputStream)input));
        Assert.assertThat((Object)"Sonar way", (Matcher)CoreMatchers.is((Object)profile.getName()));
        Assert.assertThat((Object)profile.getRules().size(), (Matcher)CoreMatchers.is((Object)2));
        org.sonar.plugins.api.maven.xml.Rule rule1 = (org.sonar.plugins.api.maven.xml.Rule)profile.getRules().get(0);
        Assert.assertThat((Object)rule1.getKey(), (Matcher)CoreMatchers.is((Object)"2006"));
        Assert.assertThat((Object)rule1.getSeverity(), (Matcher)CoreMatchers.is((Object)"warning"));
        Assert.assertNull((Object)rule1.getProperties());
        org.sonar.plugins.api.maven.xml.Rule rule2 = (org.sonar.plugins.api.maven.xml.Rule)profile.getRules().get(1);
        Assert.assertThat((Object)rule2.getKey(), (Matcher)CoreMatchers.is((Object)"2007"));
        Assert.assertThat((Object)rule2.getSeverity(), (Matcher)CoreMatchers.is((Object)"error"));
        Assert.assertThat((Object)rule2.getProperties().size(), (Matcher)CoreMatchers.is((Object)1));
        Property rule2Property = (Property)rule2.getProperties().get(0);
        Assert.assertThat((Object)rule2Property.getName(), (Matcher)CoreMatchers.is((Object)"toto"));
        Assert.assertThat((Object)rule2Property.getValue(), (Matcher)CoreMatchers.is((Object)"titi"));
    }

    @Test
    public void shouldImportConfiguration() throws IOException {
        List<Rule> inputRules = this.buildRulesFixture();
        List<ActiveRule> activeRulesExpected = this.buildActiveRulesFixture(inputRules);
        StandardProfileXmlParser standardProfileXmlParser = new StandardProfileXmlParser(inputRules);
        InputStream input = this.getClass().getResourceAsStream("/org/sonar/plugins/api/rules/test_profile.xml");
        RulesProfile profile = standardProfileXmlParser.importConfiguration(IOUtils.toString((InputStream)input));
        List results = profile.getActiveRules();
        Assert.assertThat((Object)"Sonar way", (Matcher)CoreMatchers.is((Object)profile.getName()));
        Assert.assertThat((Object)results.size(), (Matcher)CoreMatchers.is((Object)activeRulesExpected.size()));
        this.assertActiveRulesAreEquals(results, activeRulesExpected);
    }

    private List<Rule> buildRulesFixture() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Rule rule1 = new Rule("One rule", "2006", "2006", null, "MYPLUGIN", null);
        Rule rule2 = new Rule("Another rule", "2007", "2007", null, "MYPLUGIN", null);
        RuleParam ruleParam2 = new RuleParam(rule2, "toto", null, "s");
        rule2.setParams(Arrays.asList(ruleParam2));
        rules.add(rule1);
        rules.add(rule2);
        return rules;
    }

    private List<ActiveRule> buildActiveRulesFixture(List<Rule> rules) {
        ArrayList<ActiveRule> activeRules = new ArrayList<ActiveRule>();
        ActiveRule activeRule1 = new ActiveRule(null, rules.get(0), RuleFailureLevel.WARNING);
        activeRules.add(activeRule1);
        ActiveRule activeRule2 = new ActiveRule(null, rules.get(1), RuleFailureLevel.ERROR);
        activeRule2.setActiveRuleParams(Arrays.asList(new ActiveRuleParam(activeRule2, (RuleParam)rules.get(1).getParams().get(0), "titi")));
        activeRules.add(activeRule2);
        return activeRules;
    }

    private void assertActiveRulesAreEquals(List<ActiveRule> activeRules1, List<ActiveRule> activeRules2) {
        for (int i = 0; i < activeRules1.size(); ++i) {
            ActiveRule activeRule1 = activeRules1.get(i);
            ActiveRule activeRule2 = activeRules2.get(i);
            Assert.assertTrue((activeRule1.getRule().equals((Object)activeRule2.getRule()) && activeRule1.getLevel().equals((Object)activeRule2.getLevel()) ? 1 : 0) != 0);
            Assert.assertEquals((long)activeRule1.getActiveRuleParams().size(), (long)activeRule2.getActiveRuleParams().size());
            for (int j = 0; j < activeRule1.getActiveRuleParams().size(); ++j) {
                ActiveRuleParam activeRuleParam1 = (ActiveRuleParam)activeRule1.getActiveRuleParams().get(j);
                ActiveRuleParam activeRuleParam2 = (ActiveRuleParam)activeRule2.getActiveRuleParams().get(j);
                Assert.assertTrue((activeRuleParam1.getRuleParam().equals((Object)activeRuleParam2.getRuleParam()) && activeRuleParam1.getValue().equals(activeRuleParam2.getValue()) ? 1 : 0) != 0);
            }
        }
    }
}

