/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.rules;

import ch.hortis.sonar.model.Rule;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.commons.rules.RuleParam;
import org.sonar.plugins.api.rules.StandardRulesXmlParser;

public class StandardRulesXmlParserTest {
    @Test
    public void checkAllFields() {
        StandardRulesXmlParser parser = new StandardRulesXmlParser();
        String xml = "<rules><rule key='key1' category='cat1'><name>my name</name><configKey>my_config_key</configKey><description>my description</description><param key='param1'><type>s</type><description>param description</description></param><param key='param2'><type>integer</type><description>param description 2</description></param></rule></rules>";
        List rules = parser.parse(xml);
        Assert.assertEquals((long)1L, (long)rules.size());
        Rule rule = (Rule)rules.get(0);
        Assert.assertEquals((Object)"key1", (Object)rule.getKey());
        Assert.assertEquals((Object)"my name", (Object)rule.getName());
        Assert.assertEquals((Object)"my_config_key", (Object)rule.getConfigKey());
        Assert.assertEquals((Object)"my description", (Object)rule.getDescription());
        Assert.assertEquals((long)2L, (long)rule.getParams().size());
        Assert.assertEquals((Object)"param1", (Object)((RuleParam)rule.getParams().get(0)).getKey());
        Assert.assertEquals((Object)"s", (Object)((RuleParam)rule.getParams().get(0)).getType());
        Assert.assertEquals((Object)"param description", (Object)((RuleParam)rule.getParams().get(0)).getDescription());
    }

    @Test
    public void ruleShouldHaveACategory() {
        StandardRulesXmlParser parser = new StandardRulesXmlParser();
        String xml = "<rules><rule><category name='cat1' /></rule></rules>";
        List rules = parser.parse(xml);
        Assert.assertNotNull((Object)((Rule)rules.get(0)).getRulesCategory());
        Assert.assertEquals((Object)"cat1", (Object)((Rule)rules.get(0)).getRulesCategory().getName());
        Assert.assertNull((Object)((Rule)rules.get(0)).getRulesCategory().getId());
        Assert.assertNull((Object)((Rule)rules.get(0)).getRulesCategory().getDescription());
    }

    @Test
    public void shouldDefineManyRules() {
        StandardRulesXmlParser parser = new StandardRulesXmlParser();
        String xml = "<rules><rule key='key1' category='cat1' /><rule key='key2' category='cat1' /></rules>";
        List rules = parser.parse(xml);
        Assert.assertEquals((long)2L, (long)rules.size());
        Assert.assertEquals((Object)"key1", (Object)((Rule)rules.get(0)).getKey());
        Assert.assertEquals((Object)"key2", (Object)((Rule)rules.get(1)).getKey());
    }

    @Test
    public void someFielsShouldBeNull() {
        StandardRulesXmlParser parser = new StandardRulesXmlParser();
        String xml = "<rules><rule key='key1' category='cat1' /></rules>";
        List rules = parser.parse(xml);
        Assert.assertNull((Object)((Rule)rules.get(0)).getDescription());
        Assert.assertNull((Object)((Rule)rules.get(0)).getName());
        Assert.assertNull((Object)((Rule)rules.get(0)).getConfigKey());
    }

    @Test
    public void shouldContainCDataDescription() {
        StandardRulesXmlParser parser = new StandardRulesXmlParser();
        String xml = "<rules><rule key='key1' category='cat1'><description>   <![CDATA[<xml> </nodes> and accents \u00e9\u00e0\u00f2  ]]>  </description></rule></rules>";
        List rules = parser.parse(xml);
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals((Object)"   <xml> </nodes> and accents \u00e9\u00e0\u00f2    ", (Object)((Rule)rules.get(0)).getDescription());
    }

    @Test
    public void shouldBeBackwardCompatibleWithDefaultVersionProperty() {
        StandardRulesXmlParser parser = new StandardRulesXmlParser();
        String xml = "<rules><rule key='key1' category='cat1'><name>my name</name><configKey>my_config_key</configKey><param key='param1'><type>s</type><description>param description</description><defaultValue>xxx</defaultValue></param></rule></rules>";
        List rules = parser.parse(xml);
        Assert.assertEquals((long)1L, (long)rules.size());
        Rule rule = (Rule)rules.get(0);
        Assert.assertEquals((Object)"key1", (Object)rule.getKey());
        Assert.assertEquals((long)1L, (long)rule.getParams().size());
        Assert.assertEquals((Object)"param1", (Object)((RuleParam)rule.getParams().get(0)).getKey());
    }
}

