/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.ServerComponent;
import org.sonar.api.profiles.Alert;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.utils.SonarException;

public final class XMLProfileSerializer
implements ServerComponent {
    public void write(RulesProfile profile, Writer writer) {
        try {
            this.appendHeader(profile, writer);
            this.appendRules(profile, writer);
            this.appendAlerts(profile, writer);
            this.appendFooter(writer);
        }
        catch (IOException e) {
            throw new SonarException("Fail to export the profile " + profile, e);
        }
    }

    private void appendHeader(RulesProfile profile, Writer writer) throws IOException {
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- Generated by Sonar --><profile><name>");
        StringEscapeUtils.escapeXml((Writer)writer, (String)profile.getName());
        writer.append("</name><language>");
        StringEscapeUtils.escapeXml((Writer)writer, (String)profile.getLanguage());
        writer.append("</language>");
    }

    private void appendRules(RulesProfile profile, Writer writer) throws IOException {
        if (!profile.getActiveRules().isEmpty()) {
            writer.append("<rules>");
            for (ActiveRule activeRule : profile.getActiveRules()) {
                this.appendRule(activeRule, writer);
            }
            writer.append("</rules>");
        }
    }

    private void appendRule(ActiveRule activeRule, Writer writer) throws IOException {
        writer.append("<rule><repositoryKey>");
        writer.append(activeRule.getRepositoryKey());
        writer.append("</repositoryKey><key>");
        StringEscapeUtils.escapeXml((Writer)writer, (String)activeRule.getRuleKey());
        writer.append("</key>");
        if (activeRule.getSeverity() != null) {
            writer.append("<priority>");
            writer.append(activeRule.getSeverity().name());
            writer.append("</priority>");
        }
        this.appendRuleParameters(activeRule, writer);
        writer.append("</rule>");
    }

    private void appendRuleParameters(ActiveRule activeRule, Writer writer) throws IOException {
        if (activeRule.getActiveRuleParams() != null && !activeRule.getActiveRuleParams().isEmpty()) {
            writer.append("<parameters>");
            for (ActiveRuleParam activeRuleParam : activeRule.getActiveRuleParams()) {
                this.appendRuleParameter(writer, activeRuleParam);
            }
            writer.append("</parameters>");
        }
    }

    private void appendRuleParameter(Writer writer, ActiveRuleParam activeRuleParam) throws IOException {
        if (StringUtils.isNotBlank((String)activeRuleParam.getValue())) {
            writer.append("<parameter><key>");
            StringEscapeUtils.escapeXml((Writer)writer, (String)activeRuleParam.getKey());
            writer.append("</key><value>");
            StringEscapeUtils.escapeXml((Writer)writer, (String)activeRuleParam.getValue());
            writer.append("</value>");
            writer.append("</parameter>");
        }
    }

    private void appendAlerts(RulesProfile profile, Writer writer) throws IOException {
        if (!profile.getAlerts().isEmpty()) {
            writer.append("<alerts>");
            for (Alert alert : profile.getAlerts()) {
                this.appendAlert(alert, writer);
            }
            writer.append("</alerts>");
        }
    }

    private void appendAlert(Alert alert, Writer writer) throws IOException {
        writer.append("<alert><metric>");
        StringEscapeUtils.escapeXml((Writer)writer, (String)alert.getMetric().getKey());
        writer.append("</metric><operator>");
        StringEscapeUtils.escapeXml((Writer)writer, (String)alert.getOperator());
        writer.append("</operator><warning>");
        StringEscapeUtils.escapeXml((Writer)writer, (String)alert.getValueWarning());
        writer.append("</warning><error>");
        StringEscapeUtils.escapeXml((Writer)writer, (String)alert.getValueError());
        writer.append("</error></alert>");
    }

    private void appendFooter(Writer writer) throws IOException {
        writer.append("</profile>");
    }
}

