/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DelegateFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.File;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.InputFileUtils;
import org.sonar.api.resources.Java;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.Logs;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.WildcardPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DefaultProjectFileSystem
implements ProjectFileSystem {
    protected static final Predicate<java.io.File> DIRECTORY_EXISTS = new Predicate<java.io.File>(){

        public boolean apply(java.io.File input) {
            return input.exists() && input.isDirectory();
        }
    };
    private Project project;
    private Languages languages;
    private List<IOFileFilter> filters = Lists.newArrayList();

    public DefaultProjectFileSystem(Project project, Languages languages) {
        this.project = project;
        this.languages = languages;
    }

    public DefaultProjectFileSystem(Project project, Languages languages, org.sonar.api.batch.FileFilter ... fileFilters) {
        this(project, languages);
        for (org.sonar.api.batch.FileFilter fileFilter : fileFilters) {
            this.filters.add((IOFileFilter)new DelegateFileFilter((FileFilter)fileFilter));
        }
    }

    @Override
    public Charset getSourceCharset() {
        String encoding = this.project.getConfiguration().getString("sonar.sourceEncoding");
        if (StringUtils.isNotEmpty((String)encoding)) {
            try {
                return Charset.forName(encoding);
            }
            catch (Exception e) {
                Logs.INFO.warn("Can not get project charset", (Throwable)e);
            }
        }
        return Charset.defaultCharset();
    }

    @Override
    public java.io.File getBasedir() {
        return this.project.getPom().getBasedir();
    }

    @Override
    public java.io.File getBuildDir() {
        return this.resolvePath(this.project.getPom().getBuild().getDirectory());
    }

    @Override
    public java.io.File getBuildOutputDir() {
        return this.resolvePath(this.project.getPom().getBuild().getOutputDirectory());
    }

    @Override
    public List<java.io.File> getSourceDirs() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.resolvePaths(this.project.getPom().getCompileSourceRoots()), DIRECTORY_EXISTS));
    }

    @Override
    @Deprecated
    public DefaultProjectFileSystem addSourceDir(java.io.File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Can not add null to project source dirs");
        }
        this.project.getPom().getCompileSourceRoots().add(0, dir.getAbsolutePath());
        return this;
    }

    @Override
    public List<java.io.File> getTestDirs() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.resolvePaths(this.project.getPom().getTestCompileSourceRoots()), DIRECTORY_EXISTS));
    }

    @Override
    @Deprecated
    public DefaultProjectFileSystem addTestDir(java.io.File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Can not add null to project test dirs");
        }
        this.project.getPom().getTestCompileSourceRoots().add(0, dir.getAbsolutePath());
        return this;
    }

    @Override
    public java.io.File getReportOutputDir() {
        return this.resolvePath(this.project.getPom().getReporting().getOutputDirectory());
    }

    @Override
    public java.io.File getSonarWorkingDirectory() {
        try {
            java.io.File dir = new java.io.File(this.getBuildDir(), "sonar");
            FileUtils.forceMkdir((java.io.File)dir);
            return dir;
        }
        catch (IOException e) {
            throw new SonarException("Unable to retrieve Sonar working directory.", e);
        }
    }

    @Override
    public java.io.File resolvePath(String path) {
        java.io.File file = new java.io.File(path);
        if (!file.isAbsolute()) {
            try {
                file = new java.io.File(this.getBasedir(), path).getCanonicalFile();
            }
            catch (IOException e) {
                throw new SonarException("Unable to resolve path '" + path + "'", e);
            }
        }
        return file;
    }

    protected List<java.io.File> resolvePaths(List<String> paths) {
        ArrayList result = Lists.newArrayList();
        if (paths != null) {
            for (String path : paths) {
                result.add(this.resolvePath(path));
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public List<java.io.File> getSourceFiles(Language ... langs) {
        return DefaultProjectFileSystem.toFiles(this.mainFiles(this.getLanguageKeys(langs)));
    }

    @Override
    @Deprecated
    public List<java.io.File> getJavaSourceFiles() {
        return this.getSourceFiles(Java.INSTANCE);
    }

    @Override
    public boolean hasJavaSourceFiles() {
        return !this.mainFiles("java").isEmpty();
    }

    @Override
    @Deprecated
    public List<java.io.File> getTestFiles(Language ... langs) {
        return DefaultProjectFileSystem.toFiles(this.testFiles(this.getLanguageKeys(langs)));
    }

    @Override
    @Deprecated
    public boolean hasTestFiles(Language lang) {
        return !this.testFiles(lang.getKey()).isEmpty();
    }

    private List<InputFile> getFiles(List<java.io.File> directories, List<java.io.File> initialFiles, boolean applyExclusionPatterns, String ... langs) {
        ArrayList result = Lists.newArrayList();
        if (directories == null) {
            return result;
        }
        IOFileFilter suffixFilter = this.getFileSuffixFilter(langs);
        WildcardPattern[] exclusionPatterns = this.getExclusionPatterns(applyExclusionPatterns);
        IOFileFilter initialFilesFilter = TrueFileFilter.INSTANCE;
        if (initialFiles != null && !initialFiles.isEmpty()) {
            initialFilesFilter = new FileSelectionFilter(initialFiles);
        }
        for (java.io.File dir : directories) {
            if (!dir.exists()) continue;
            ExclusionFilter exclusionFilter = new ExclusionFilter(dir, exclusionPatterns);
            IOFileFilter visibleFileFilter = HiddenFileFilter.VISIBLE;
            ArrayList fileFilters = Lists.newArrayList((Object[])new IOFileFilter[]{visibleFileFilter, suffixFilter, exclusionFilter, initialFilesFilter});
            fileFilters.addAll(this.filters);
            List files = (List)FileUtils.listFiles((java.io.File)dir, (IOFileFilter)new AndFileFilter((List)fileFilters), (IOFileFilter)HiddenFileFilter.VISIBLE);
            for (java.io.File file : files) {
                String relativePath = DefaultProjectFileSystem.getRelativePath(file, dir);
                result.add(InputFileUtils.create(dir, relativePath));
            }
        }
        return result;
    }

    private WildcardPattern[] getExclusionPatterns(boolean applyExclusionPatterns) {
        WildcardPattern[] exclusionPatterns = applyExclusionPatterns ? WildcardPattern.create(this.project.getExclusionPatterns()) : new WildcardPattern[]{};
        return exclusionPatterns;
    }

    private IOFileFilter getFileSuffixFilter(String ... langKeys) {
        List<String> suffixes;
        IOFileFilter suffixFilter = FileFilterUtils.trueFileFilter();
        if (langKeys != null && langKeys.length > 0 && !(suffixes = Arrays.asList(this.languages.getSuffixes(langKeys))).isEmpty()) {
            suffixFilter = new SuffixFileFilter(suffixes);
        }
        return suffixFilter;
    }

    @Override
    public java.io.File writeToWorkingDirectory(String content, String fileName) throws IOException {
        return DefaultProjectFileSystem.writeToFile(content, this.getSonarWorkingDirectory(), fileName);
    }

    protected static java.io.File writeToFile(String content, java.io.File dir, String fileName) throws IOException {
        java.io.File file = new java.io.File(dir, fileName);
        FileUtils.writeStringToFile((java.io.File)file, (String)content, (String)"UTF-8");
        return file;
    }

    public static String getRelativePath(java.io.File file, java.io.File dir) {
        return DefaultProjectFileSystem.getRelativePath(file, Arrays.asList(dir));
    }

    public static String getRelativePath(java.io.File file, List<java.io.File> dirs) {
        ArrayList<String> stack = new ArrayList<String>();
        String path = FilenameUtils.normalize((String)file.getAbsolutePath());
        for (java.io.File cursor = new java.io.File(path); cursor != null; cursor = cursor.getParentFile()) {
            if (DefaultProjectFileSystem.containsFile(dirs, cursor)) {
                return StringUtils.join(stack, (String)"/");
            }
            stack.add(0, cursor.getName());
        }
        return null;
    }

    @Override
    public java.io.File getFileFromBuildDirectory(String filename) {
        java.io.File file = new java.io.File(this.getBuildDir(), filename);
        return file.exists() ? file : null;
    }

    @Override
    public Resource toResource(java.io.File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        String relativePath = DefaultProjectFileSystem.getRelativePath(file, this.getSourceDirs());
        if (relativePath == null) {
            return null;
        }
        return file.isFile() ? new File(relativePath) : new Directory(relativePath);
    }

    private static boolean containsFile(List<java.io.File> dirs, java.io.File cursor) {
        for (java.io.File dir : dirs) {
            if (!FilenameUtils.equalsNormalizedOnSystem((String)dir.getAbsolutePath(), (String)cursor.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private String[] getLanguageKeys(Language[] langs) {
        String[] keys = new String[langs.length];
        for (int i = 0; i < langs.length; ++i) {
            keys[i] = langs[i].getKey();
        }
        return keys;
    }

    private static List<java.io.File> toFiles(List<InputFile> files) {
        ArrayList result = Lists.newArrayList();
        for (InputFile file : files) {
            result.add(file.getFile());
        }
        return result;
    }

    @Override
    public List<InputFile> mainFiles(String ... langs) {
        return this.getFiles(this.getSourceDirs(), this.getInitialSourceFiles(), true, langs);
    }

    @Override
    public List<InputFile> testFiles(String ... langs) {
        return this.getFiles(this.getTestDirs(), this.getInitialTestFiles(), false, langs);
    }

    protected List<java.io.File> getInitialSourceFiles() {
        return Collections.emptyList();
    }

    protected List<java.io.File> getInitialTestFiles() {
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileSelectionFilter
    implements IOFileFilter {
        private Set<java.io.File> files;

        public FileSelectionFilter(List<java.io.File> f) {
            this.files = Sets.newHashSet(f);
        }

        public boolean accept(java.io.File file) {
            return this.files.contains(file);
        }

        public boolean accept(java.io.File file, String name) {
            return this.accept(file);
        }
    }

    private static class ExclusionFilter
    implements IOFileFilter {
        java.io.File sourceDir;
        WildcardPattern[] patterns;

        ExclusionFilter(java.io.File sourceDir, WildcardPattern[] patterns) {
            this.sourceDir = sourceDir;
            this.patterns = patterns;
        }

        public boolean accept(java.io.File file) {
            String relativePath = DefaultProjectFileSystem.getRelativePath(file, this.sourceDir);
            if (relativePath == null) {
                return false;
            }
            for (WildcardPattern pattern : this.patterns) {
                if (!pattern.match(relativePath)) continue;
                return false;
            }
            return true;
        }

        public boolean accept(java.io.File file, String name) {
            return this.accept(file);
        }
    }
}

