/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Map;
import java.util.TreeMap;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.KeyValueFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBuilder<KEY, VALUE> {
    private Metric metric;
    private Map<KEY, VALUE> props;

    public PropertiesBuilder(Metric metric, Map<KEY, VALUE> map) {
        this.props = new TreeMap<KEY, VALUE>(map);
        this.metric = metric;
    }

    public PropertiesBuilder(Metric metric) {
        this.props = new TreeMap<KEY, VALUE>();
        this.metric = metric;
    }

    public PropertiesBuilder() {
        this.props = new TreeMap<KEY, VALUE>();
    }

    public PropertiesBuilder<KEY, VALUE> clear() {
        this.props.clear();
        return this;
    }

    public Map<KEY, VALUE> getProps() {
        return this.props;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public PropertiesBuilder<KEY, VALUE> setMetric(Metric metric) {
        this.metric = metric;
        return this;
    }

    public PropertiesBuilder<KEY, VALUE> add(KEY key, VALUE value) {
        this.props.put(key, value);
        return this;
    }

    public PropertiesBuilder<KEY, VALUE> addAll(Map<KEY, VALUE> map) {
        this.props.putAll(map);
        return this;
    }

    public Measure build() {
        return new Measure(this.metric, this.buildData());
    }

    public String buildData() {
        return KeyValueFormat.format(this.props);
    }
}

