/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import org.sonar.check.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RulePriority {
    INFO,
    MINOR,
    MAJOR,
    CRITICAL,
    BLOCKER;


    public static RulePriority valueOfString(String level) {
        try {
            return RulePriority.valueOf(level.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            if (level.equalsIgnoreCase("ERROR")) {
                return MAJOR;
            }
            if (level.equalsIgnoreCase("WARNING")) {
                return INFO;
            }
            throw new IllegalArgumentException("Unknown priority " + level);
        }
    }

    public static RulePriority fromCheckPriority(Priority checkPriority) {
        if (checkPriority == Priority.BLOCKER) {
            return BLOCKER;
        }
        if (checkPriority == Priority.CRITICAL) {
            return CRITICAL;
        }
        if (checkPriority == Priority.MAJOR) {
            return MAJOR;
        }
        if (checkPriority == Priority.MINOR) {
            return MINOR;
        }
        if (checkPriority == Priority.INFO) {
            return INFO;
        }
        return null;
    }

    public Priority toCheckPriority() {
        if (this == BLOCKER) {
            return Priority.BLOCKER;
        }
        if (this == CRITICAL) {
            return Priority.CRITICAL;
        }
        if (this == MAJOR) {
            return Priority.MAJOR;
        }
        if (this == MINOR) {
            return Priority.MINOR;
        }
        if (this == INFO) {
            return Priority.INFO;
        }
        return null;
    }
}

