/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.checks;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Check;
import org.sonar.check.CheckProperty;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationCheckFactory
extends CheckFactory {
    private Map<String, Class> checkClassesByKey = Maps.newHashMap();

    private AnnotationCheckFactory(RulesProfile profile, String repositoryKey, Collection<Class> checkClasses) {
        super(profile, repositoryKey);
        this.groupClassesByKey(checkClasses);
    }

    public static AnnotationCheckFactory create(RulesProfile profile, String repositoryKey, Collection<Class> checkClasses) {
        AnnotationCheckFactory factory = new AnnotationCheckFactory(profile, repositoryKey, checkClasses);
        factory.init();
        return factory;
    }

    private void groupClassesByKey(Collection<Class> checkClasses) {
        for (Class checkClass : checkClasses) {
            String key = this.getRuleKey(checkClass);
            if (key == null) continue;
            this.checkClassesByKey.put(key, checkClass);
        }
    }

    protected Object createCheck(ActiveRule activeRule) {
        Class clazz = this.checkClassesByKey.get(activeRule.getConfigKey());
        if (clazz != null) {
            return this.instantiate(activeRule, clazz);
        }
        return null;
    }

    private Object instantiate(ActiveRule activeRule, Class clazz) {
        try {
            Object check = clazz.newInstance();
            this.configureFields(activeRule, check);
            return check;
        }
        catch (InstantiationException e) {
            throw new SonarException("Can not instantiate the check related to the rule " + activeRule, e);
        }
        catch (IllegalAccessException e) {
            throw new SonarException("Can not instantiate the check related to the rule " + activeRule, e);
        }
    }

    private void configureFields(ActiveRule activeRule, Object check) {
        for (ActiveRuleParam param : activeRule.getActiveRuleParams()) {
            Field field = this.getField(check, param.getKey());
            if (field == null) {
                throw new SonarException("The field " + param.getKey() + " does not exist or is not annotated with @RuleProperty in the class " + check.getClass().getName());
            }
            if (!StringUtils.isNotBlank((String)param.getValue())) continue;
            this.configureField(check, field, param.getValue());
        }
    }

    private void configureField(Object check, Field field, String value) {
        block13: {
            try {
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(check, value);
                    break block13;
                }
                if ("int".equals(field.getType().getSimpleName())) {
                    field.setInt(check, Integer.parseInt(value));
                    break block13;
                }
                if ("short".equals(field.getType().getSimpleName())) {
                    field.setShort(check, Short.parseShort(value));
                    break block13;
                }
                if ("long".equals(field.getType().getSimpleName())) {
                    field.setLong(check, Long.parseLong(value));
                    break block13;
                }
                if ("double".equals(field.getType().getSimpleName())) {
                    field.setDouble(check, Double.parseDouble(value));
                    break block13;
                }
                if ("boolean".equals(field.getType().getSimpleName())) {
                    field.setBoolean(check, Boolean.parseBoolean(value));
                    break block13;
                }
                if ("byte".equals(field.getType().getSimpleName())) {
                    field.setByte(check, Byte.parseByte(value));
                    break block13;
                }
                if (field.getType().equals(Integer.class)) {
                    field.set(check, Integer.parseInt(value));
                    break block13;
                }
                if (field.getType().equals(Long.class)) {
                    field.set(check, Long.parseLong(value));
                    break block13;
                }
                if (field.getType().equals(Double.class)) {
                    field.set(check, Double.parseDouble(value));
                    break block13;
                }
                if (field.getType().equals(Boolean.class)) {
                    field.set(check, Boolean.parseBoolean(value));
                    break block13;
                }
                throw new SonarException("The type of the field " + field + " is not supported: " + field.getType());
            }
            catch (IllegalAccessException e) {
                throw new SonarException("Can not set the value of the field " + field + " in the class: " + check.getClass().getName(), e);
            }
        }
    }

    private Field getField(Object check, String key) {
        Field[] fields;
        for (Field field : fields = check.getClass().getDeclaredFields()) {
            CheckProperty checkAnnotation;
            RuleProperty propertyAnnotation = field.getAnnotation(RuleProperty.class);
            if (!(propertyAnnotation != null ? StringUtils.equals((String)key, (String)field.getName()) || StringUtils.equals((String)key, (String)propertyAnnotation.key()) : (checkAnnotation = field.getAnnotation(CheckProperty.class)) != null && (StringUtils.equals((String)key, (String)field.getName()) || StringUtils.equals((String)key, (String)checkAnnotation.key())))) continue;
            return field;
        }
        return null;
    }

    private String getRuleKey(Class annotatedClass) {
        String key = null;
        Rule ruleAnnotation = annotatedClass.getAnnotation(Rule.class);
        if (ruleAnnotation != null) {
            key = ruleAnnotation.key();
        } else {
            Check checkAnnotation = annotatedClass.getAnnotation(Check.class);
            if (checkAnnotation != null) {
                key = checkAnnotation.key();
            }
        }
        return StringUtils.defaultIfEmpty((String)key, (String)annotatedClass.getCanonicalName());
    }
}

