/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.rules.Rule;

@Entity
@Table(name="rules_parameters")
public class RuleParam {
    @Id
    @Column(name="id")
    @GeneratedValue
    private Integer id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="rule_id")
    private Rule rule;
    @Column(name="name", updatable=true, nullable=false, length=128)
    private String key;
    @Column(name="description", updatable=true, nullable=true, length=4000)
    private String description;
    @Column(name="param_type", updatable=true, nullable=true, length=512)
    private String type = "s";
    @Column(name="default_value", updatable=true, nullable=true, length=4000)
    private String defaultValue;

    @Deprecated
    public RuleParam() {
    }

    @Deprecated
    public RuleParam(Rule rule, String key, String description, String type) {
        this.rule = rule;
        this.key = key;
        this.description = description;
        this.type = type;
    }

    public Rule getRule() {
        return this.rule;
    }

    RuleParam setRule(Rule rule) {
        this.rule = rule;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public RuleParam setKey(String key) {
        this.key = key;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public RuleParam setDescription(String s) {
        this.description = StringUtils.defaultString((String)s, (String)"");
        return this;
    }

    public String getType() {
        return this.type;
    }

    public RuleParam setType(String type) {
        this.type = type;
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Boolean getDefaultValueAsBoolean() {
        if (this.defaultValue != null) {
            return Boolean.parseBoolean(this.defaultValue);
        }
        return null;
    }

    public Integer getDefaultValueAsInteger() {
        if (this.defaultValue != null) {
            return Integer.parseInt(this.defaultValue);
        }
        return null;
    }

    public RuleParam setDefaultValue(String s) {
        this.defaultValue = s;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RuleParam)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RuleParam other = (RuleParam)obj;
        return other.key.equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("key", (Object)this.key).append("desc", (Object)this.description).append("type", (Object)this.type).toString();
    }
}

