/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.dag;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.dag.CyclicDependenciesException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
implements Comparable<Node> {
    private final Object object;
    private int order = 0;
    private boolean seen = false;
    private final List<Node> dependencies = new ArrayList<Node>();

    public Node(Object object) {
        if (object == null) {
            throw new SonarException("object can not be null");
        }
        this.object = object;
    }

    public void reset() {
        this.order = 0;
        this.seen = false;
    }

    public Object getObject() {
        return this.object;
    }

    public void addDependency(Node v) {
        if (!this.equals(v) && !this.dependencies.contains(v)) {
            this.dependencies.add(v);
        }
    }

    public void resolveOrder() throws CyclicDependenciesException {
        this.resolveOrder(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int resolveOrder(String path) throws CyclicDependenciesException {
        this.seen = true;
        try {
            int highOrder = -1;
            for (Node dep : this.dependencies) {
                if (dep.seen) {
                    throw new CyclicDependenciesException(path + " -> " + dep.toString());
                }
                highOrder = Math.max(highOrder, dep.resolveOrder(path + " -> " + dep.toString()));
            }
            int n = this.order = highOrder + 1;
            return n;
        }
        finally {
            this.seen = false;
        }
    }

    public List<Node> getDependencies() {
        return this.dependencies;
    }

    @Override
    public int compareTo(Node other) {
        int orderInd = 0;
        if (this.order < other.order) {
            orderInd = -1;
        } else if (this.order > other.order) {
            orderInd = 1;
        }
        return orderInd;
    }

    public int getOrder() {
        return this.order;
    }

    public String toString() {
        return this.object.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        return this.object.equals(((Node)o).getObject());
    }

    public int hashCode() {
        return this.object.hashCode();
    }
}

