/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Map;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.SortedBag;
import org.apache.commons.collections.bag.TreeBag;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureBuilder;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.api.utils.SonarException;

public class CountDistributionBuilder
implements MeasureBuilder {
    private Metric metric;
    private SortedBag countBag;

    public CountDistributionBuilder(Metric metric) {
        this.setMetric(metric);
        this.countBag = new TreeBag();
    }

    public CountDistributionBuilder add(Object value, int count) {
        if (count == 0) {
            this.addZero(value);
        } else if (this.countBag.add(value, count)) {
            this.countBag.add(value, 1);
        }
        return this;
    }

    public CountDistributionBuilder add(Object value) {
        return this.add(value, 1);
    }

    public CountDistributionBuilder addZero(Object value) {
        if (!this.countBag.contains(value)) {
            this.countBag.add(value, 1);
        }
        return this;
    }

    public CountDistributionBuilder add(Measure measure) {
        if (measure != null && measure.getData() != null) {
            Map map = KeyValueFormat.parse(measure.getData());
            for (Map.Entry entry : map.entrySet()) {
                int value;
                String key = (String)entry.getKey();
                int n = value = StringUtils.isBlank((String)((String)entry.getValue())) ? 0 : Integer.parseInt((String)entry.getValue());
                if (NumberUtils.isNumber((String)key)) {
                    this.add(NumberUtils.toInt((String)key), value);
                    continue;
                }
                this.add(key, value);
            }
        }
        return this;
    }

    public boolean isEmpty() {
        return this.countBag.isEmpty();
    }

    public CountDistributionBuilder clear() {
        this.countBag.clear();
        return this;
    }

    public Measure build() {
        return this.build(true);
    }

    public Measure build(boolean allowEmptyData) {
        if (!this.isEmpty() || allowEmptyData) {
            return new Measure(this.metric, KeyValueFormat.format((Bag)this.countBag, -1));
        }
        return null;
    }

    private void setMetric(Metric metric) {
        if (metric == null || !metric.isDataType()) {
            throw new SonarException("Metric is null or has unvalid type");
        }
        this.metric = metric;
    }
}

