/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2008-2011 SonarSource
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.api.utils;

import org.apache.commons.lang.ClassUtils;

import java.util.List;

/**
 * A utility class for annotations
 *
 * @since 1.11
 */
public final class AnnotationUtils {

  private AnnotationUtils() {
  }

  /**
   * Searches for a class annotation. All inheritance tree is analysed.
   */
  public static <A> A getClassAnnotation(final Object object, final Class<A> annotationClass) {
    Class initialClass = (object instanceof Class ? (Class) object : object.getClass());
    A result = null;
    Class aClass=initialClass;
    while (aClass != null && result == null) {
      result = (A)aClass.getAnnotation(annotationClass);
      aClass = aClass.getSuperclass();
    }

    if (result==null) {
      List<Class> interfaces = ClassUtils.getAllInterfaces(initialClass);
      for (Class anInterface : interfaces) {
        result = (A)anInterface.getAnnotation(annotationClass);
        if (result!=null) {
          break;
        }
      }
    }
    return result;
  }
}
