/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import org.sonar.check.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RulePriority {
    INFO,
    MINOR,
    MAJOR,
    CRITICAL,
    BLOCKER;


    public static RulePriority valueOfString(String level) {
        try {
            return RulePriority.valueOf(level.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            if ("ERROR".equalsIgnoreCase(level)) {
                return MAJOR;
            }
            if ("WARNING".equalsIgnoreCase(level)) {
                return INFO;
            }
            throw new IllegalArgumentException("Unknown priority " + level);
        }
    }

    public static RulePriority fromCheckPriority(Priority checkPriority) {
        if (checkPriority == Priority.BLOCKER) {
            return BLOCKER;
        }
        if (checkPriority == Priority.CRITICAL) {
            return CRITICAL;
        }
        if (checkPriority == Priority.MAJOR) {
            return MAJOR;
        }
        if (checkPriority == Priority.MINOR) {
            return MINOR;
        }
        if (checkPriority == Priority.INFO) {
            return INFO;
        }
        throw new IllegalArgumentException("Unknown priority " + checkPriority);
    }
}

