/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldUtils2 {
    private FieldUtils2() {
    }

    public static List<Field> getFields(Class clazz, boolean forceAccess) {
        ArrayList result = Lists.newArrayList();
        for (Class c = clazz; c != null; c = c.getSuperclass()) {
            for (Field declaredField : c.getDeclaredFields()) {
                if (!Modifier.isPublic(declaredField.getModifiers())) {
                    if (!forceAccess) continue;
                    declaredField.setAccessible(true);
                }
                result.add(declaredField);
            }
        }
        for (Object anInterface : ClassUtils.getAllInterfaces((Class)clazz)) {
            Collections.addAll(result, ((Class)anInterface).getDeclaredFields());
        }
        return result;
    }
}

