/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.util.Arrays;
import java.util.Collection;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.TruePredicate;

class OrPredicate
implements FilePredicate {
    private final Collection<FilePredicate> predicates;

    OrPredicate(Collection<FilePredicate> predicates) {
        this.predicates = predicates.isEmpty() ? Arrays.asList(TruePredicate.TRUE) : predicates;
    }

    @Override
    public boolean apply(InputFile f) {
        for (FilePredicate predicate : this.predicates) {
            if (!predicate.apply(f)) continue;
            return true;
        }
        return false;
    }
}

