/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.ServerComponent;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.internal.Category;
import org.sonar.api.config.internal.SubCategory;
import org.sonar.api.utils.AnnotationUtils;

public final class PropertyDefinitions
implements BatchComponent,
ServerComponent {
    private final Map<String, PropertyDefinition> definitions = Maps.newHashMap();
    private final Map<String, Category> categories = Maps.newHashMap();
    private final Map<String, SubCategory> subcategories = Maps.newHashMap();
    private final Map<String, String> deprecatedKeys = Maps.newHashMap();

    public PropertyDefinitions(Object ... components) {
        if (components != null) {
            this.addComponents(Arrays.asList(components));
        }
    }

    public PropertyDefinitions(Collection<PropertyDefinition> components) {
        this.addComponents(components);
    }

    public PropertyDefinitions addComponents(Collection components) {
        return this.addComponents(components, "");
    }

    public PropertyDefinitions addComponents(Collection components, String defaultCategory) {
        for (Object component : components) {
            this.addComponent(component, defaultCategory);
        }
        return this;
    }

    public PropertyDefinitions addComponent(Object object) {
        return this.addComponent(object, "");
    }

    public PropertyDefinitions addComponent(Object component, String defaultCategory) {
        this.addComponentFromAnnotationProperty(component, defaultCategory);
        if (component instanceof PropertyDefinition) {
            PropertyDefinition propertyDefinition = (PropertyDefinition)component;
            this.add(propertyDefinition, defaultCategory);
        }
        return this;
    }

    private PropertyDefinitions addComponentFromAnnotationProperty(Object component, String defaultCategory) {
        Property annotation;
        Properties annotations = AnnotationUtils.getAnnotation(component, Properties.class);
        if (annotations != null) {
            for (Property property : annotations.value()) {
                this.addProperty(property, defaultCategory);
            }
        }
        if ((annotation = AnnotationUtils.getAnnotation(component, Property.class)) != null) {
            this.addProperty(annotation, defaultCategory);
        }
        return this;
    }

    private PropertyDefinitions addProperty(Property property, String defaultCategory) {
        PropertyDefinition definition = PropertyDefinition.create(property);
        return this.add(definition, defaultCategory);
    }

    private PropertyDefinitions add(PropertyDefinition definition, String defaultCategory) {
        if (!this.definitions.containsKey(definition.key())) {
            this.definitions.put(definition.key(), definition);
            String category = StringUtils.defaultIfBlank((String)definition.category(), (String)defaultCategory);
            this.categories.put(definition.key(), new Category(category));
            String subcategory = StringUtils.defaultIfBlank((String)definition.subCategory(), (String)category);
            this.subcategories.put(definition.key(), new SubCategory(subcategory));
            if (!Strings.isNullOrEmpty((String)definition.deprecatedKey()) && !definition.deprecatedKey().equals(definition.key())) {
                this.deprecatedKeys.put(definition.deprecatedKey(), definition.key());
            }
        }
        return this;
    }

    public PropertyDefinition get(String key) {
        return this.definitions.get(this.validKey(key));
    }

    public Collection<PropertyDefinition> getAll() {
        return this.definitions.values();
    }

    public String validKey(String key) {
        return StringUtils.defaultString((String)this.deprecatedKeys.get(key), (String)key);
    }

    @Deprecated
    public Map<String, Map<String, Collection<PropertyDefinition>>> getPropertiesByCategory(@Nullable String qualifier) {
        HashMap<String, Map<String, Collection<PropertyDefinition>>> byCategory = new HashMap<String, Map<String, Collection<PropertyDefinition>>>();
        for (PropertyDefinition definition : this.getAll()) {
            if (!(qualifier == null ? definition.global() : definition.qualifiers().contains(qualifier))) continue;
            String category = this.getCategory(definition.key());
            if (!byCategory.containsKey(category)) {
                byCategory.put(category, new HashMap());
            }
            String subCategory = this.getSubCategory(definition.key());
            if (!((Map)byCategory.get(category)).containsKey(subCategory)) {
                ((Map)byCategory.get(category)).put(subCategory, new ArrayList());
            }
            ((Collection)((Map)byCategory.get(category)).get(subCategory)).add(definition);
        }
        return byCategory;
    }

    @Deprecated
    public Map<String, Map<String, Collection<PropertyDefinition>>> getPropertiesByCategory() {
        return this.getPropertiesByCategory(null);
    }

    public Map<Category, Map<SubCategory, Collection<PropertyDefinition>>> propertiesByCategory(@Nullable String qualifier) {
        HashMap<Category, Map<SubCategory, Collection<PropertyDefinition>>> byCategory = new HashMap<Category, Map<SubCategory, Collection<PropertyDefinition>>>();
        if (qualifier == null) {
            HashMap emailSubCategories = new HashMap();
            emailSubCategories.put(new SubCategory("email", true), new ArrayList());
            byCategory.put(new Category("general", false), emailSubCategories);
            HashMap licenseSubCategories = new HashMap();
            licenseSubCategories.put(new SubCategory("server_id", true), new ArrayList());
            byCategory.put(new Category("licenses", false), licenseSubCategories);
            HashMap encryptionSubCategories = new HashMap();
            encryptionSubCategories.put(new SubCategory("encryption", true), new ArrayList());
            byCategory.put(new Category("security", false), encryptionSubCategories);
        }
        for (PropertyDefinition definition : this.getAll()) {
            if (!(qualifier == null ? definition.global() : definition.qualifiers().contains(qualifier))) continue;
            Category category = this.categories.get(definition.key());
            if (!byCategory.containsKey(category)) {
                byCategory.put(category, new HashMap());
            }
            SubCategory subCategory = this.subcategories.get(definition.key());
            if (!((Map)byCategory.get(category)).containsKey(subCategory)) {
                ((Map)byCategory.get(category)).put(subCategory, new ArrayList());
            }
            ((Collection)((Map)byCategory.get(category)).get(subCategory)).add(definition);
        }
        return byCategory;
    }

    public String getDefaultValue(String key) {
        PropertyDefinition def = this.get(key);
        if (def == null) {
            return null;
        }
        return StringUtils.defaultIfEmpty((String)def.defaultValue(), null);
    }

    public String getCategory(String key) {
        return this.categories.get(this.validKey(key)).toString();
    }

    public String getSubCategory(String key) {
        return this.subcategories.get(this.validKey(key)).toString();
    }

    public String getCategory(Property prop) {
        return this.getCategory(prop.key());
    }

    public String getNewKey(String deprecatedKey) {
        return this.deprecatedKeys.get(deprecatedKey);
    }

    public String getDeprecatedKey(String key) {
        PropertyDefinition def = this.get(key);
        if (def == null) {
            return null;
        }
        return StringUtils.defaultIfEmpty((String)def.deprecatedKey(), null);
    }
}

