/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.IssueComment;
import org.sonar.api.issue.internal.DefaultIssueComment;
import org.sonar.api.issue.internal.FieldDiffs;
import org.sonar.api.issue.internal.IssueChangeContext;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;
import org.sonar.api.utils.internal.WorkDuration;

public class DefaultIssue
implements Issue {
    private String key;
    private String componentKey;
    private Long componentId;
    private String projectKey;
    private RuleKey ruleKey;
    private String severity;
    private boolean manualSeverity = false;
    private String message;
    private Integer line;
    private Double effortToFix;
    private WorkDuration technicalDebt;
    private String status;
    private String resolution;
    private String reporter;
    private String assignee;
    private String checksum;
    private Map<String, String> attributes = null;
    private String authorLogin = null;
    private String actionPlanKey;
    private List<IssueComment> comments = null;
    private Date creationDate;
    private Date updateDate;
    private Date closeDate;
    private FieldDiffs currentChange = null;
    private List<FieldDiffs> changes = null;
    private boolean isNew = true;
    private boolean endOfLife = false;
    private boolean onDisabledRule = false;
    private boolean isChanged = false;
    private boolean sendNotifications = false;
    private Date selectedAt;

    @Override
    public String key() {
        return this.key;
    }

    public DefaultIssue setKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public String componentKey() {
        return this.componentKey;
    }

    public DefaultIssue setComponentKey(String s) {
        this.componentKey = s;
        return this;
    }

    @CheckForNull
    public Long componentId() {
        return this.componentId;
    }

    public DefaultIssue setComponentId(@Nullable Long s) {
        this.componentId = s;
        return this;
    }

    @CheckForNull
    public String projectKey() {
        return this.projectKey;
    }

    public DefaultIssue setProjectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    @Override
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    public DefaultIssue setRuleKey(RuleKey k) {
        this.ruleKey = k;
        return this;
    }

    @Override
    public String severity() {
        return this.severity;
    }

    public DefaultIssue setSeverity(@Nullable String s) {
        Preconditions.checkArgument((s == null || Severity.ALL.contains(s) ? 1 : 0) != 0, (Object)("Not a valid severity: " + s));
        this.severity = s;
        return this;
    }

    public boolean manualSeverity() {
        return this.manualSeverity;
    }

    public DefaultIssue setManualSeverity(boolean b) {
        this.manualSeverity = b;
        return this;
    }

    @Override
    @CheckForNull
    public String message() {
        return this.message;
    }

    public DefaultIssue setMessage(@Nullable String s) {
        this.message = StringUtils.abbreviate((String)StringUtils.trim((String)s), (int)4000);
        return this;
    }

    @Override
    @CheckForNull
    public Integer line() {
        return this.line;
    }

    public DefaultIssue setLine(@Nullable Integer l) {
        Preconditions.checkArgument((l == null || l > 0 ? 1 : 0) != 0, (Object)("Line must be null or greater than zero (got " + l + ")"));
        this.line = l;
        return this;
    }

    @Override
    @CheckForNull
    public Double effortToFix() {
        return this.effortToFix;
    }

    public DefaultIssue setEffortToFix(@Nullable Double d) {
        Preconditions.checkArgument((d == null || d >= 0.0 ? 1 : 0) != 0, (Object)("Effort to fix must be greater than or equal 0 (got " + d + ")"));
        this.effortToFix = d;
        return this;
    }

    @CheckForNull
    public WorkDuration technicalDebt() {
        return this.technicalDebt;
    }

    public DefaultIssue setTechnicalDebt(@Nullable WorkDuration t) {
        this.technicalDebt = t;
        return this;
    }

    @Override
    public String status() {
        return this.status;
    }

    public DefaultIssue setStatus(String s) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)s) ? 1 : 0) != 0, (Object)"Status must be set");
        this.status = s;
        return this;
    }

    @Override
    @CheckForNull
    public String resolution() {
        return this.resolution;
    }

    public DefaultIssue setResolution(@Nullable String s) {
        this.resolution = s;
        return this;
    }

    @Override
    @CheckForNull
    public String reporter() {
        return this.reporter;
    }

    public DefaultIssue setReporter(@Nullable String s) {
        this.reporter = s;
        return this;
    }

    @Override
    @CheckForNull
    public String assignee() {
        return this.assignee;
    }

    public DefaultIssue setAssignee(@Nullable String s) {
        this.assignee = s;
        return this;
    }

    @Override
    public Date creationDate() {
        return this.creationDate;
    }

    public DefaultIssue setCreationDate(Date d) {
        this.creationDate = d != null ? DateUtils.truncate((Date)d, (int)13) : null;
        return this;
    }

    @Override
    @CheckForNull
    public Date updateDate() {
        return this.updateDate;
    }

    public DefaultIssue setUpdateDate(@Nullable Date d) {
        this.updateDate = d != null ? DateUtils.truncate((Date)d, (int)13) : null;
        return this;
    }

    @Override
    @CheckForNull
    public Date closeDate() {
        return this.closeDate;
    }

    public DefaultIssue setCloseDate(@Nullable Date d) {
        this.closeDate = d != null ? DateUtils.truncate((Date)d, (int)13) : null;
        return this;
    }

    @CheckForNull
    public String checksum() {
        return this.checksum;
    }

    public DefaultIssue setChecksum(@Nullable String s) {
        this.checksum = s;
        return this;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    public DefaultIssue setNew(boolean b) {
        this.isNew = b;
        return this;
    }

    public boolean isEndOfLife() {
        return this.endOfLife;
    }

    public DefaultIssue setEndOfLife(boolean b) {
        this.endOfLife = b;
        return this;
    }

    public boolean isOnDisabledRule() {
        return this.onDisabledRule;
    }

    public DefaultIssue setOnDisabledRule(boolean b) {
        this.onDisabledRule = b;
        return this;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public DefaultIssue setChanged(boolean b) {
        this.isChanged = b;
        return this;
    }

    public boolean mustSendNotifications() {
        return this.sendNotifications;
    }

    public DefaultIssue setSendNotifications(boolean b) {
        this.sendNotifications = b;
        return this;
    }

    @Override
    @CheckForNull
    public String attribute(String key) {
        return this.attributes == null ? null : this.attributes.get(key);
    }

    public DefaultIssue setAttribute(String key, @Nullable String value) {
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        return this;
    }

    @Override
    public Map<String, String> attributes() {
        return this.attributes == null ? Collections.emptyMap() : ImmutableMap.copyOf(this.attributes);
    }

    public DefaultIssue setAttributes(@Nullable Map<String, String> map) {
        if (map != null) {
            if (this.attributes == null) {
                this.attributes = Maps.newHashMap();
            }
            this.attributes.putAll(map);
        }
        return this;
    }

    @Override
    @CheckForNull
    public String authorLogin() {
        return this.authorLogin;
    }

    public DefaultIssue setAuthorLogin(@Nullable String s) {
        this.authorLogin = s;
        return this;
    }

    @Override
    @CheckForNull
    public String actionPlanKey() {
        return this.actionPlanKey;
    }

    public DefaultIssue setActionPlanKey(@Nullable String actionPlanKey) {
        this.actionPlanKey = actionPlanKey;
        return this;
    }

    public DefaultIssue setFieldChange(IssueChangeContext context, String field, @Nullable Serializable oldValue, @Nullable Serializable newValue) {
        if (!Objects.equal((Object)oldValue, (Object)newValue)) {
            if (this.currentChange == null) {
                this.currentChange = new FieldDiffs();
                this.currentChange.setUserLogin(context.login());
                this.currentChange.setCreationDate(context.date());
            }
            this.currentChange.setDiff(field, oldValue, newValue);
        }
        this.addChange(this.currentChange);
        return this;
    }

    @CheckForNull
    public FieldDiffs currentChange() {
        return this.currentChange;
    }

    public DefaultIssue addChange(FieldDiffs change) {
        if (this.changes == null) {
            this.changes = Lists.newArrayList();
        }
        this.changes.add(change);
        return this;
    }

    public DefaultIssue setChanges(List<FieldDiffs> changes) {
        this.changes = changes;
        return this;
    }

    public List<FieldDiffs> changes() {
        if (this.changes == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.changes);
    }

    public DefaultIssue addComment(DefaultIssueComment comment) {
        if (this.comments == null) {
            this.comments = Lists.newArrayList();
        }
        this.comments.add(comment);
        return this;
    }

    @Override
    public List<IssueComment> comments() {
        if (this.comments == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.comments);
    }

    @CheckForNull
    public Date selectedAt() {
        return this.selectedAt;
    }

    public DefaultIssue setSelectedAt(@Nullable Date d) {
        this.selectedAt = d;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIssue that = (DefaultIssue)o;
        return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

