/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonar.api.measures.Formula;
import org.sonar.api.measures.FormulaContext;
import org.sonar.api.measures.FormulaData;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.resources.Scopes;

public class SumChildDistributionFormula
implements Formula {
    private String minimumScopeToPersist = "FIL";

    @Override
    public List<Metric> dependsUponMetrics() {
        return Collections.emptyList();
    }

    public String getMinimumScopeToPersist() {
        return this.minimumScopeToPersist;
    }

    public SumChildDistributionFormula setMinimumScopeToPersist(String s) {
        this.minimumScopeToPersist = s;
        return this;
    }

    @Override
    public Measure calculate(FormulaData data, FormulaContext context) {
        Collection<Measure> measures = data.getChildrenMeasures(context.getTargetMetric());
        if (measures == null || measures.isEmpty()) {
            return null;
        }
        RangeDistributionBuilder distribution = new RangeDistributionBuilder(context.getTargetMetric());
        for (Measure measure : measures) {
            distribution.add(measure);
        }
        Measure measure = distribution.build();
        if (!Scopes.isHigherThanOrEquals(context.getResource().getScope(), this.minimumScopeToPersist)) {
            measure.setPersistenceMode(PersistenceMode.MEMORY);
        }
        return measure;
    }
}

