/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Language;

public abstract class Resource
implements Serializable {
    @Deprecated
    public static final String SCOPE_SET = "PRJ";
    @Deprecated
    public static final String SCOPE_SPACE = "DIR";
    @Deprecated
    public static final String SCOPE_ENTITY = "FIL";
    @Deprecated
    public static final String QUALIFIER_VIEW = "VW";
    @Deprecated
    public static final String QUALIFIER_SUBVIEW = "SVW";
    @Deprecated
    public static final String QUALIFIER_LIB = "LIB";
    @Deprecated
    public static final String QUALIFIER_PROJECT = "TRK";
    @Deprecated
    public static final String QUALIFIER_MODULE = "BRC";
    @Deprecated
    public static final String QUALIFIER_PACKAGE = "PAC";
    @Deprecated
    public static final String QUALIFIER_DIRECTORY = "DIR";
    @Deprecated
    public static final String QUALIFIER_FILE = "FIL";
    @Deprecated
    public static final String QUALIFIER_CLASS = "CLA";
    @Deprecated
    public static final String QUALIFIER_FIELD = "FLD";
    @Deprecated
    public static final String QUALIFIER_METHOD = "MET";
    @Deprecated
    public static final String QUALIFIER_UNIT_TEST_CLASS = "UTS";
    private Integer id = null;
    private String key = null;
    private String deprecatedKey = null;
    private String path = null;
    private String effectiveKey = null;

    public final String getKey() {
        return this.key;
    }

    public void setKey(String s) {
        this.key = s;
    }

    public final String getDeprecatedKey() {
        return this.deprecatedKey;
    }

    public void setDeprecatedKey(String s) {
        this.deprecatedKey = s;
    }

    public abstract String getName();

    public abstract String getLongName();

    public abstract String getDescription();

    public abstract Language getLanguage();

    public abstract String getScope();

    public abstract String getQualifier();

    public abstract Resource getParent();

    public abstract boolean matchFilePattern(String var1);

    public final Integer getId() {
        return this.id;
    }

    public Resource setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public Resource setPath(@Nullable String path) {
        this.path = Resource.normalize(path);
        return this;
    }

    @CheckForNull
    protected static String normalize(@Nullable String path) {
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        String normalizedPath = path;
        normalizedPath = normalizedPath.replace('\\', '/');
        if ("/".equals(normalizedPath = StringUtils.trim((String)normalizedPath))) {
            return "/";
        }
        normalizedPath = StringUtils.removeStart((String)normalizedPath, (String)"/");
        normalizedPath = StringUtils.removeEnd((String)normalizedPath, (String)"/");
        return normalizedPath;
    }

    public String getEffectiveKey() {
        return this.effectiveKey;
    }

    public final Resource setEffectiveKey(String effectiveKey) {
        this.effectiveKey = effectiveKey;
        return this;
    }

    @Deprecated
    public final boolean isExcluded() {
        return false;
    }

    @Deprecated
    public final Resource setExcluded(boolean b) {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        if (this.key != null) {
            return this.key.equals(resource.key);
        }
        return resource.key == null && this.deprecatedKey.equals(resource.deprecatedKey);
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : this.deprecatedKey.hashCode();
    }
}

