/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.rule.RuleDefinitions;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.FieldUtils2;
import org.sonar.check.Cardinality;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

class RuleDefinitionsFromAnnotations {
    private static final Logger LOG = LoggerFactory.getLogger(RuleDefinitionsFromAnnotations.class);
    private static final Function<Class<?>, RuleParamType> TYPE_FOR_CLASS = Functions.forMap((Map)ImmutableMap.builder().put(Integer.class, (Object)RuleParamType.INTEGER).put(Integer.TYPE, (Object)RuleParamType.INTEGER).put(Float.class, (Object)RuleParamType.FLOAT).put(Float.TYPE, (Object)RuleParamType.FLOAT).put(Boolean.class, (Object)RuleParamType.BOOLEAN).put(Boolean.TYPE, (Object)RuleParamType.BOOLEAN).build(), (Object)RuleParamType.STRING);

    RuleDefinitionsFromAnnotations() {
    }

    void loadRules(RuleDefinitions.NewRepository repo, Class ... annotatedClasses) {
        for (Class annotatedClass : annotatedClasses) {
            this.loadRule(repo, annotatedClass);
        }
    }

    @CheckForNull
    RuleDefinitions.NewRule loadRule(RuleDefinitions.NewRepository repo, Class clazz) {
        Rule ruleAnnotation = AnnotationUtils.getAnnotation(clazz, Rule.class);
        if (ruleAnnotation != null) {
            return this.loadRule(repo, clazz, ruleAnnotation);
        }
        LOG.warn("The class " + clazz.getCanonicalName() + " should be annotated with " + Rule.class);
        return null;
    }

    private RuleDefinitions.NewRule loadRule(RuleDefinitions.NewRepository repo, Class clazz, Rule ruleAnnotation) {
        String ruleKey = StringUtils.defaultIfEmpty((String)ruleAnnotation.key(), (String)clazz.getCanonicalName());
        String ruleName = StringUtils.defaultIfEmpty((String)ruleAnnotation.name(), null);
        String description = StringUtils.defaultIfEmpty((String)ruleAnnotation.description(), null);
        RuleDefinitions.NewRule rule = repo.newRule(ruleKey);
        rule.setName(ruleName).setHtmlDescription(description);
        rule.setSeverity(ruleAnnotation.priority().name());
        rule.setTemplate(ruleAnnotation.cardinality() == Cardinality.MULTIPLE);
        rule.setStatus(RuleStatus.valueOf(ruleAnnotation.status()));
        rule.setTags(ruleAnnotation.tags());
        List<Field> fields = FieldUtils2.getFields(clazz, true);
        for (Field field : fields) {
            this.loadParameters(rule, field);
        }
        return rule;
    }

    private void loadParameters(RuleDefinitions.NewRule rule, Field field) {
        RuleProperty propertyAnnotation = field.getAnnotation(RuleProperty.class);
        if (propertyAnnotation != null) {
            String fieldKey = StringUtils.defaultIfEmpty((String)propertyAnnotation.key(), (String)field.getName());
            RuleDefinitions.NewParam param = rule.newParam(fieldKey).setDescription(propertyAnnotation.description()).setDefaultValue(propertyAnnotation.defaultValue());
            if (!StringUtils.isBlank((String)propertyAnnotation.type())) {
                try {
                    param.setType(RuleParamType.parse(propertyAnnotation.type().trim()));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid property type [" + propertyAnnotation.type() + "]", e);
                }
            } else {
                param.setType(RuleDefinitionsFromAnnotations.guessType(field.getType()));
            }
        }
    }

    @VisibleForTesting
    static RuleParamType guessType(Class<?> type) {
        return (RuleParamType)TYPE_FOR_CLASS.apply(type);
    }
}

