/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.ServerExtension;
import org.sonar.api.server.ws.RequestHandler;

public interface WebService
extends ServerExtension {
    public void define(Context var1);

    @Immutable
    public static class Param {
        private final String key;
        private final String description;

        public Param(NewParam newParam) {
            this.key = newParam.key;
            this.description = newParam.description;
        }

        public String key() {
            return this.key;
        }

        @CheckForNull
        public String description() {
            return this.description;
        }

        public String toString() {
            return this.key;
        }
    }

    public static class NewParam {
        private String key;
        private String description;

        private NewParam(String key) {
            this.key = key;
        }

        public NewParam setDescription(@Nullable String s) {
            this.description = s;
            return this;
        }

        public String toString() {
            return this.key;
        }
    }

    @Immutable
    public static class Action {
        private final String key;
        private final String path;
        private final String description;
        private final String since;
        private final boolean post;
        private final boolean isInternal;
        private final RequestHandler handler;
        private final Map<String, Param> params;

        private Action(Controller controller, NewAction newAction) {
            this.key = newAction.key;
            this.path = String.format("%s/%s", controller.path(), this.key);
            this.description = newAction.description;
            this.since = StringUtils.defaultIfBlank((String)newAction.since, (String)controller.since);
            this.post = newAction.post;
            this.isInternal = newAction.isInternal;
            if (newAction.handler == null) {
                throw new IllegalStateException("RequestHandler is not set on action " + this.path);
            }
            this.handler = newAction.handler;
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (NewParam newParam : newAction.newParams.values()) {
                mapBuilder.put((Object)newParam.key, (Object)new Param(newParam));
            }
            this.params = mapBuilder.build();
        }

        public String key() {
            return this.key;
        }

        public String path() {
            return this.path;
        }

        @CheckForNull
        public String description() {
            return this.description;
        }

        @CheckForNull
        public String since() {
            return this.since;
        }

        public boolean isPost() {
            return this.post;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public RequestHandler handler() {
            return this.handler;
        }

        @CheckForNull
        public Param param(String key) {
            return this.params.get(key);
        }

        public Collection<Param> params() {
            return this.params.values();
        }

        public String toString() {
            return this.path;
        }
    }

    public static class NewAction {
        private final String key;
        private String description;
        private String since;
        private boolean post = false;
        private boolean isInternal = false;
        private RequestHandler handler;
        private Map<String, NewParam> newParams = Maps.newHashMap();

        private NewAction(String key) {
            this.key = key;
        }

        public NewAction setDescription(@Nullable String s) {
            this.description = s;
            return this;
        }

        public NewAction setSince(@Nullable String s) {
            this.since = s;
            return this;
        }

        public NewAction setPost(boolean b) {
            this.post = b;
            return this;
        }

        public NewAction setInternal(boolean b) {
            this.isInternal = b;
            return this;
        }

        public NewAction setHandler(RequestHandler h) {
            this.handler = h;
            return this;
        }

        public NewParam createParam(String paramKey) {
            if (this.newParams.containsKey(paramKey)) {
                throw new IllegalStateException(String.format("The parameter '%s' is defined multiple times in the action '%s'", paramKey, this.key));
            }
            NewParam newParam = new NewParam(paramKey);
            this.newParams.put(paramKey, newParam);
            return newParam;
        }

        public NewAction createParam(String paramKey, @Nullable String description) {
            this.createParam(paramKey).setDescription(description);
            return this;
        }
    }

    @Immutable
    public static class Controller {
        private final String path;
        private final String description;
        private final String since;
        private final Map<String, Action> actions;

        private Controller(NewController newController) {
            if (newController.actions.isEmpty()) {
                throw new IllegalStateException(String.format("At least one action must be declared in the web service '%s'", newController.path));
            }
            this.path = newController.path;
            this.description = newController.description;
            this.since = newController.since;
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (NewAction newAction : newController.actions.values()) {
                mapBuilder.put((Object)newAction.key, (Object)new Action(this, newAction));
            }
            this.actions = mapBuilder.build();
        }

        public String path() {
            return this.path;
        }

        @CheckForNull
        public String description() {
            return this.description;
        }

        @CheckForNull
        public String since() {
            return this.since;
        }

        @CheckForNull
        public Action action(String actionKey) {
            return this.actions.get(actionKey);
        }

        public Collection<Action> actions() {
            return this.actions.values();
        }
    }

    public static class NewController {
        private final Context context;
        private final String path;
        private String description;
        private String since;
        private final Map<String, NewAction> actions = Maps.newHashMap();

        private NewController(Context context, String path) {
            if (StringUtils.isBlank((String)path)) {
                throw new IllegalArgumentException("WS controller path must not be empty");
            }
            if (StringUtils.startsWith((String)path, (String)"/") || StringUtils.endsWith((String)path, (String)"/")) {
                throw new IllegalArgumentException("WS controller path must not start or end with slash: " + path);
            }
            this.context = context;
            this.path = path;
        }

        public void done() {
            this.context.register(this);
        }

        public NewController setDescription(@Nullable String s) {
            this.description = s;
            return this;
        }

        public NewController setSince(@Nullable String s) {
            this.since = s;
            return this;
        }

        public NewAction createAction(String actionKey) {
            if (this.actions.containsKey(actionKey)) {
                throw new IllegalStateException(String.format("The action '%s' is defined multiple times in the web service '%s'", actionKey, this.path));
            }
            NewAction action = new NewAction(actionKey);
            this.actions.put(actionKey, action);
            return action;
        }
    }

    public static class Context {
        private final Map<String, Controller> controllers = Maps.newHashMap();

        public NewController createController(String path) {
            return new NewController(this, path);
        }

        private void register(NewController newController) {
            if (this.controllers.containsKey(newController.path)) {
                throw new IllegalStateException(String.format("The web service '%s' is defined multiple times", newController.path));
            }
            this.controllers.put(newController.path, new Controller(newController));
        }

        @CheckForNull
        public Controller controller(String key) {
            return this.controllers.get(key);
        }

        public List<Controller> controllers() {
            return ImmutableList.copyOf(this.controllers.values());
        }
    }
}

