/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.technicaldebt.server.internal;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.technicaldebt.server.Characteristic;
import org.sonar.api.utils.WorkUnit;
import org.sonar.api.utils.internal.WorkDuration;

public class DefaultCharacteristic
implements Characteristic {
    private Integer id;
    private String key;
    private String name;
    private Integer order;
    private Integer parentId;
    private Integer rootId;
    private RuleKey ruleKey;
    private String function;
    private Integer factorValue;
    private WorkDuration.UNIT factorUnit;
    private Integer offsetValue;
    private WorkDuration.UNIT offsetUnit;

    @Override
    public Integer id() {
        return this.id;
    }

    public DefaultCharacteristic setId(Integer id) {
        this.id = id;
        return this;
    }

    @Override
    @CheckForNull
    public String key() {
        return this.key;
    }

    public DefaultCharacteristic setKey(@Nullable String key) {
        this.key = key;
        return this;
    }

    @Override
    @CheckForNull
    public String name() {
        return this.name;
    }

    public DefaultCharacteristic setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Override
    @CheckForNull
    public Integer order() {
        return this.order;
    }

    public DefaultCharacteristic setOrder(@Nullable Integer order) {
        this.order = order;
        return this;
    }

    @Override
    @CheckForNull
    public Integer parentId() {
        return this.parentId;
    }

    public DefaultCharacteristic setParentId(@Nullable Integer parentId) {
        this.parentId = parentId;
        return this;
    }

    @Override
    @CheckForNull
    public Integer rootId() {
        return this.rootId;
    }

    public DefaultCharacteristic setRootId(@Nullable Integer rootId) {
        this.rootId = rootId;
        return this;
    }

    @Override
    @CheckForNull
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    public DefaultCharacteristic setRuleKey(@Nullable RuleKey ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @Override
    @CheckForNull
    public String function() {
        return this.function;
    }

    public DefaultCharacteristic setFunction(@Nullable String function) {
        this.function = function;
        return this;
    }

    @Override
    @Deprecated
    @CheckForNull
    public WorkUnit factor() {
        if (this.factorValue != null && this.factorUnit != null) {
            return WorkUnit.create((double)this.factorValue, DefaultCharacteristic.fromUnit(this.factorUnit));
        }
        return null;
    }

    @Deprecated
    public DefaultCharacteristic setFactor(@Nullable WorkUnit factor) {
        if (factor != null) {
            this.factorValue = (int)factor.getValue();
            this.factorUnit = DefaultCharacteristic.toUnit(factor.getUnit());
        }
        return this;
    }

    @Override
    @CheckForNull
    public Integer factorValue() {
        return this.factorValue;
    }

    public DefaultCharacteristic setFactorValue(@Nullable Integer factorValue) {
        this.factorValue = factorValue;
        return this;
    }

    @Override
    @CheckForNull
    public WorkDuration.UNIT factorUnit() {
        return this.factorUnit;
    }

    public DefaultCharacteristic setFactorUnit(@Nullable WorkDuration.UNIT factorUnit) {
        this.factorUnit = factorUnit;
        return this;
    }

    @Override
    @Deprecated
    public WorkUnit offset() {
        if (this.offsetValue != null && this.offsetUnit != null) {
            return WorkUnit.create((double)this.offsetValue, DefaultCharacteristic.fromUnit(this.offsetUnit));
        }
        return null;
    }

    @Deprecated
    public DefaultCharacteristic setOffset(@Nullable WorkUnit offset) {
        if (offset != null) {
            this.offsetValue = (int)offset.getValue();
            this.offsetUnit = DefaultCharacteristic.toUnit(offset.getUnit());
        }
        return this;
    }

    @Override
    @CheckForNull
    public Integer offsetValue() {
        return this.offsetValue;
    }

    public DefaultCharacteristic setOffsetValue(@Nullable Integer offsetValue) {
        this.offsetValue = offsetValue;
        return this;
    }

    @Override
    @CheckForNull
    public WorkDuration.UNIT offsetUnit() {
        return this.offsetUnit;
    }

    public DefaultCharacteristic setOffsetUnit(@Nullable WorkDuration.UNIT offsetUnit) {
        this.offsetUnit = offsetUnit;
        return this;
    }

    public static WorkDuration.UNIT toUnit(@Nullable String requirementUnit) {
        if (requirementUnit != null) {
            if ("d".equals(requirementUnit)) {
                return WorkDuration.UNIT.DAYS;
            }
            if ("h".equals(requirementUnit)) {
                return WorkDuration.UNIT.HOURS;
            }
            if ("mn".equals(requirementUnit)) {
                return WorkDuration.UNIT.MINUTES;
            }
            throw new IllegalStateException("Invalid unit : " + requirementUnit);
        }
        return null;
    }

    private static String fromUnit(WorkDuration.UNIT unit) {
        if (WorkDuration.UNIT.DAYS.equals((Object)unit)) {
            return "d";
        }
        if (WorkDuration.UNIT.HOURS.equals((Object)unit)) {
            return "h";
        }
        if (WorkDuration.UNIT.MINUTES.equals((Object)unit)) {
            return "mn";
        }
        throw new IllegalStateException("Invalid unit : " + (Object)((Object)unit));
    }

    @Override
    public boolean isRoot() {
        return this.parentId == null;
    }

    @Override
    public boolean isRequirement() {
        return this.ruleKey != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCharacteristic that = (DefaultCharacteristic)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.ruleKey != null ? !this.ruleKey.equals(that.ruleKey) : that.ruleKey != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.ruleKey != null ? this.ruleKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

