/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.internal;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.TempFolder;

public class DefaultTempFolder
implements TempFolder {
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private final File tempDir;

    public DefaultTempFolder(File tempDir) {
        this.tempDir = tempDir;
    }

    @Override
    public File newDir() {
        return DefaultTempFolder.createTempDir(this.tempDir, "");
    }

    private static File createTempDir(File baseDir, String prefix) {
        String baseName = prefix + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException(MessageFormat.format("Failed to create directory within {0} attempts (tried {1} to {2})", 10000, baseName + 0, baseName + 9999));
    }

    @Override
    public File newDir(String name) {
        File dir = new File(this.tempDir, name);
        try {
            FileUtils.forceMkdir((File)dir);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp directory in " + dir, e);
        }
        return dir;
    }

    @Override
    public File newFile() {
        return this.newFile(null, null);
    }

    @Override
    public File newFile(@Nullable String prefix, @Nullable String suffix) {
        return DefaultTempFolder.createTempFile(this.tempDir, prefix, suffix);
    }

    private static File createTempFile(File baseDir, String prefix, String suffix) {
        String baseName = StringUtils.defaultIfEmpty((String)prefix, (String)"") + System.currentTimeMillis() + "-";
        try {
            for (int counter = 0; counter < 10000; ++counter) {
                File tempFile = new File(baseDir, baseName + counter + suffix);
                if (!tempFile.createNewFile()) continue;
                return tempFile;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp file", e);
        }
        throw new IllegalStateException(MessageFormat.format("Failed to create temp file within {0} attempts (tried {1} to {2})", 10000, baseName + 0 + suffix, baseName + 9999 + suffix));
    }

    public void clean() {
        FileUtils.deleteQuietly((File)this.tempDir);
    }
}

