/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class WorkDuration
implements Serializable {
    static final int DAY_POSITION_IN_LONG = 10000;
    static final int HOUR_POSITION_IN_LONG = 100;
    static final int MINUTE_POSITION_IN_LONG = 1;
    private int hoursInDay;
    private long durationInSeconds;
    private int days;
    private int hours;
    private int minutes;

    private WorkDuration(long durationInSeconds, int days, int hours, int minutes, int hoursInDay) {
        this.durationInSeconds = durationInSeconds;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.hoursInDay = hoursInDay;
    }

    public static WorkDuration create(int days, int hours, int minutes, int hoursInDay) {
        long durationInSeconds = 3600L * (long)days * (long)hoursInDay;
        durationInSeconds += 3600L * (long)hours;
        return new WorkDuration(durationInSeconds += 60L * (long)minutes, days, hours, minutes, hoursInDay);
    }

    public static WorkDuration createFromValueAndUnit(int value, UNIT unit, int hoursInDay) {
        switch (unit) {
            case DAYS: {
                return WorkDuration.create(value, 0, 0, hoursInDay);
            }
            case HOURS: {
                return WorkDuration.create(0, value, 0, hoursInDay);
            }
            case MINUTES: {
                return WorkDuration.create(0, 0, value, hoursInDay);
            }
        }
        throw new IllegalStateException("Cannot create work duration");
    }

    static WorkDuration createFromLong(long duration, int hoursInDay) {
        int days = 0;
        int hours = 0;
        int minutes = 0;
        long time = duration;
        Long currentTime = time / 10000L;
        if (currentTime > 0L) {
            days = currentTime.intValue();
            time -= currentTime * 10000L;
        }
        if ((currentTime = Long.valueOf(time / 100L)) > 0L) {
            hours = currentTime.intValue();
            time -= currentTime * 100L;
        }
        if ((currentTime = Long.valueOf(time / 1L)) > 0L) {
            minutes = currentTime.intValue();
        }
        return WorkDuration.create(days, hours, minutes, hoursInDay);
    }

    static WorkDuration createFromSeconds(long seconds, int hoursInDay) {
        int days = (int)((float)(seconds / (long)hoursInDay) / 60.0f / 60.0f);
        long currentDurationInSeconds = seconds - 3600L * (long)days * (long)hoursInDay;
        int hours = (int)((float)currentDurationInSeconds / 60.0f / 60.0f);
        int minutes = (int)((float)(currentDurationInSeconds -= 3600L * (long)hours) / 60.0f);
        return new WorkDuration(seconds, days, hours, minutes, hoursInDay);
    }

    public double toWorkingDays() {
        return (double)this.durationInSeconds / 60.0 / 60.0 / (double)this.hoursInDay;
    }

    public long toLong() {
        int workingDays = this.days;
        int workingHours = this.hours;
        if (this.hours >= this.hoursInDay) {
            int nbAdditionalDays = this.hours / this.hoursInDay;
            workingDays += nbAdditionalDays;
            workingHours = this.hours - nbAdditionalDays * this.hoursInDay;
        }
        return workingDays * 10000 + workingHours * 100 + this.minutes * 1;
    }

    public long toSeconds() {
        return this.durationInSeconds;
    }

    public WorkDuration add(@Nullable WorkDuration with) {
        if (with != null) {
            return WorkDuration.createFromSeconds(this.toSeconds() + with.toSeconds(), this.hoursInDay);
        }
        return this;
    }

    public WorkDuration subtract(@Nullable WorkDuration with) {
        if (with != null) {
            return WorkDuration.createFromSeconds(this.toSeconds() - with.toSeconds(), this.hoursInDay);
        }
        return this;
    }

    public WorkDuration multiply(int factor) {
        return WorkDuration.createFromSeconds(this.toSeconds() * (long)factor, this.hoursInDay);
    }

    public int days() {
        return this.days;
    }

    public int hours() {
        return this.hours;
    }

    public int minutes() {
        return this.minutes;
    }

    @VisibleForTesting
    int hoursInDay() {
        return this.hoursInDay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkDuration that = (WorkDuration)o;
        return this.durationInSeconds == that.durationInSeconds;
    }

    public int hashCode() {
        return (int)(this.durationInSeconds ^ this.durationInSeconds >>> 32);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static enum UNIT {
        DAYS,
        HOURS,
        MINUTES;

    }
}

