/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.text;

import java.io.Writer;
import java.util.Date;
import javax.annotation.Nullable;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.text.WriterException;

public class JsonWriter {
    private final com.google.gson.stream.JsonWriter stream;

    public static JsonWriter of(Writer writer) {
        return new JsonWriter(writer);
    }

    private JsonWriter(Writer writer) {
        this.stream = new com.google.gson.stream.JsonWriter(writer);
        this.stream.setSerializeNulls(false);
        this.stream.setLenient(false);
    }

    JsonWriter(com.google.gson.stream.JsonWriter stream) {
        this.stream = stream;
    }

    public JsonWriter beginArray() {
        try {
            this.stream.beginArray();
            return this;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public JsonWriter endArray() {
        try {
            this.stream.endArray();
            return this;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public JsonWriter beginObject() {
        try {
            this.stream.beginObject();
            return this;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public JsonWriter endObject() {
        try {
            this.stream.endObject();
            return this;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public JsonWriter name(String name) {
        try {
            this.stream.name(name);
            return this;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public JsonWriter value(boolean value) {
        try {
            this.stream.value(value);
            return this;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public JsonWriter value(double value) {
        try {
            this.stream.value(value);
            return this;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public JsonWriter value(@Nullable String value) {
        try {
            this.stream.value(value);
            return this;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public JsonWriter valueDate(@Nullable Date value) {
        try {
            this.stream.value(value == null ? null : DateUtils.formatDate(value));
            return this;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public JsonWriter valueDateTime(@Nullable Date value) {
        try {
            this.stream.value(value == null ? null : DateUtils.formatDateTime(value));
            return this;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public JsonWriter value(long value) {
        try {
            this.stream.value(value);
            return this;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public JsonWriter value(@Nullable Number value) {
        try {
            this.stream.value(value);
            return this;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public JsonWriter prop(String name, @Nullable Number value) {
        return this.name(name).value(value);
    }

    public JsonWriter propDate(String name, @Nullable Date value) {
        return this.name(name).valueDate(value);
    }

    public JsonWriter propDateTime(String name, @Nullable Date value) {
        return this.name(name).valueDateTime(value);
    }

    public JsonWriter prop(String name, @Nullable String value) {
        return this.name(name).value(value);
    }

    public JsonWriter prop(String name, boolean value) {
        return this.name(name).value(value);
    }

    public JsonWriter prop(String name, long value) {
        return this.name(name).value(value);
    }

    public JsonWriter prop(String name, double value) {
        return this.name(name).value(value);
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    private IllegalStateException rethrow(Exception e) {
        throw new WriterException("Fail to write JSON: " + e.getMessage());
    }
}

