/*
 * Decompiled with CFR 0.152.
 */
package anyframe.common.aop.aspects;

import net.sf.infrared.agent.MonitorConfig;
import net.sf.infrared.agent.MonitorFacade;
import net.sf.infrared.agent.MonitorFactory;
import net.sf.infrared.agent.StatisticsCollector;
import net.sf.infrared.base.model.ExecutionContext;
import net.sf.infrared.base.model.ExecutionTimer;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public abstract class AbstractAspects
implements MethodInterceptor {
    private MonitorFacade monitorFacade = null;

    public Object recordExecution(ExecutionContext ctx, MethodInvocation sjp) throws Throwable {
        if (this.monitorFacade == null) {
            return this.recordExecution(ctx, sjp, MonitorFactory.getFacade());
        }
        return this.recordExecution(ctx, sjp, this.monitorFacade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object recordExecution(ExecutionContext ctx, MethodInvocation sjp, MonitorFacade facade) throws Throwable {
        ExecutionTimer timer = new ExecutionTimer(ctx);
        StatisticsCollector collector = facade.recordExecutionBegin(timer);
        try {
            Object object = sjp.proceed();
            return object;
        }
        finally {
            facade.recordExecutionEnd(timer, collector);
        }
    }

    public boolean isMonitoringEnabled() {
        MonitorFacade facade = this.monitorFacade == null ? MonitorFactory.getFacade() : this.monitorFacade;
        return this.isMonitoringEnabled(facade);
    }

    public boolean isMonitoringEnabled(MonitorFacade facade) {
        MonitorConfig cfg = facade.getConfiguration();
        return cfg.isMonitoringEnabled();
    }

    public void setMonitorFacade(MonitorFacade monitorFacade) {
        this.monitorFacade = monitorFacade;
    }
}

