/*
 * Decompiled with CFR 0.152.
 */
package anyframe.common.aop.aspects;

import anyframe.common.aop.aspects.AbstractAspects;
import java.sql.Connection;
import java.sql.SQLException;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6Connection;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6Factory;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcAspect
extends AbstractAspects {
    private static Log log = LogFactory.getLog((String)"anyframe.monitoring");
    private InfraREDP6Factory factory = new InfraREDP6Factory();

    public Object invoke(MethodInvocation jp) throws Throwable {
        Object rtObject = jp.proceed();
        if (rtObject == null || !(rtObject instanceof Connection)) {
            return rtObject;
        }
        Connection con = (Connection)rtObject;
        if (!(con instanceof InfraREDP6Connection)) {
            try {
                con = this.factory.getConnection(con);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Wrapped Connection with the Infrared P6 connection " + con));
                }
            }
            catch (SQLException sqlex) {
                log.error((Object)"Failed to wrap Connection with the Infrared P6 connection", (Throwable)sqlex);
            }
        }
        return con;
    }
}

