/*
 * Decompiled with CFR 0.152.
 */
package anyframe.common.exception;

import anyframe.common.exception.message.AnyFrameMessageSource;
import anyframe.common.exception.message.Message;
import anyframe.common.exception.message.MessageHandler;
import org.springframework.context.MessageSource;

public class BaseException
extends Exception
implements AnyFrameMessageSource {
    private static final long serialVersionUID = 1L;
    protected String messageKey;
    protected Object[] messageParameters;
    protected Message message = new Message();

    public BaseException(MessageSource messageSource, String messageKey, Object[] messageParameters, String defaultMessage, Throwable wrappedException) {
        super(wrappedException);
        this.messageKey = messageKey;
        this.messageParameters = messageParameters;
        this.message = MessageHandler.handleExMessage(messageSource, messageKey, messageParameters, defaultMessage);
    }

    public BaseException(MessageSource messageSource, String messageKey, Object[] messageParameters, Throwable wrappedException) {
        this(messageSource, messageKey, messageParameters, null, wrappedException);
    }

    public BaseException(MessageSource messageSource, String messageKey, Throwable wrappedException) {
        this(messageSource, messageKey, null, null, wrappedException);
    }

    public BaseException(MessageSource messageSource, String messageKey, String defaultMessage, Throwable wrappedException) {
        this(messageSource, messageKey, null, defaultMessage, wrappedException);
    }

    public BaseException(MessageSource messageSource, String messageKey, Object[] messageParameters) {
        this(messageSource, messageKey, messageParameters, null, null);
    }

    public BaseException(MessageSource messageSource, String messageKey, Object[] messageParameters, String defaultMessage) {
        this(messageSource, messageKey, messageParameters, defaultMessage, null);
    }

    public BaseException(MessageSource messageSource, String messageKey) {
        this(messageSource, messageKey, null, null, null);
    }

    public BaseException(MessageSource messageSource, String messageKey, String defaultMessage) {
        this(messageSource, messageKey, null, defaultMessage, null);
    }

    public BaseException(String message, Object[] messageParameters, Throwable wrappedException) {
        super(wrappedException);
        this.messageParameters = messageParameters;
        this.message = MessageHandler.handleExMessage(message, messageParameters);
    }

    public BaseException(String message, Object[] messageParameters) {
        this(message, messageParameters, null);
    }

    public BaseException() {
        this("BaseRTException without message", null, null);
    }

    public BaseException(String message) {
        this(message, null, null);
    }

    public BaseException(String message, Throwable exception) {
        this(message, null, exception);
    }

    public Message getMessages() {
        return this.message;
    }

    public String getMessage() {
        return this.message.getUserMessage();
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public Object[] getMessageParameters() {
        return this.messageParameters;
    }

    public void setMessageParameters(Object[] messageParameters) {
        this.messageParameters = messageParameters;
    }
}

