/*
 * Decompiled with CFR 0.152.
 */
package anyframe.common.util;

import anyframe.common.Constants;
import anyframe.common.util.StringUtil;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.springframework.context.i18n.LocaleContextHolder;

public abstract class DateUtil {
    private static String defaultDatePattern = null;
    private static final String DATE_PATTERN = "yyyy-MM-dd";

    private DateUtil() {
    }

    public static String getEndDate(String startDay, int intervalDays) {
        StringTokenizer st = new StringTokenizer(startDay, "-");
        int year = 0;
        int mon = 0;
        int day = 0;
        int i = 0;
        while (st.hasMoreTokens()) {
            if (i == 0) {
                year = Integer.parseInt(st.nextToken());
            }
            if (i == 1) {
                String sMon = st.nextToken();
                if (sMon.startsWith("0")) {
                    sMon = sMon.substring(1);
                }
                mon = Integer.parseInt(sMon);
            }
            if (i == 2) {
                String sDay = st.nextToken();
                if (sDay.startsWith("0")) {
                    sDay = sDay.substring(1);
                }
                day = Integer.parseInt(sDay);
            }
            ++i;
        }
        DateTime start = new DateTime(year, mon, day, 0, 0, 0, 0);
        Period p1 = new Period(1728000000L);
        Period p2 = new Period((long)((intervalDays - 20) * 86400000));
        DateTime end = start.plus((ReadablePeriod)p1);
        end = end.plus((ReadablePeriod)p2);
        year = end.getYear();
        mon = end.getMonthOfYear();
        day = end.getDayOfMonth();
        String xMon = "";
        String xDay = "";
        xMon = mon < 10 ? "0" + new Integer(mon).toString() : new Integer(mon).toString();
        xDay = day < 10 ? "0" + new Integer(day).toString() : new Integer(day).toString();
        String endDay = new Integer(year).toString() + "-" + xMon + "-" + xDay;
        return endDay;
    }

    public static synchronized String getDefaultDatePattern() {
        Locale locale = LocaleContextHolder.getLocale();
        try {
            defaultDatePattern = ResourceBundle.getBundle(Constants.BUNDLE_KEY, locale).getString("date.format");
        }
        catch (Exception mse) {
            defaultDatePattern = DATE_PATTERN;
        }
        return defaultDatePattern;
    }

    public static boolean greaterThan(Date date1, String date2) {
        return DateUtil.greaterThan(date1, date2, DATE_PATTERN);
    }

    public static boolean greaterThan(Date date1, String date2, String date2format) {
        Date date = DateUtil.string2Date(date2, date2format);
        return DateUtil.greaterThan(date1, date);
    }

    public static boolean greaterThan(Date date1, Date date2) {
        return date1.getTime() > date2.getTime();
    }

    public static boolean equals(Date date1, String date2) {
        return DateUtil.equals(date1, date2, DATE_PATTERN);
    }

    public static boolean equals(Date date1, String date2, String date2format) {
        Date date = DateUtil.string2Date(date2, date2format);
        return DateUtil.equals(date1, date);
    }

    public static boolean equals(Date date1, Date date2) {
        return date1.getTime() == date2.getTime();
    }

    public static java.sql.Date string2SQLDate(String date) throws Exception {
        return DateUtil.string2SQLDate(date, DATE_PATTERN);
    }

    public static java.sql.Date string2SQLDate(String date, String format) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dateFormat = null;
        dateFormat = sdf.parse(date);
        java.sql.Date sqlDate = new java.sql.Date(dateFormat.getTime());
        return sqlDate;
    }

    public static String date2String(Date date) {
        return DateUtil.date2String(date, DATE_PATTERN);
    }

    public static String date2String(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Date string2Date(String str) {
        return DateUtil.string2Date(str, DATE_PATTERN);
    }

    public static Date string2Date(String str, String format) {
        Date d = null;
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        d = sdf.parse(str, new ParsePosition(0));
        return d;
    }

    public static Timestamp string2Timestamp(String str, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date strDate = dateFormat.parse(str, new ParsePosition(0));
        long strTime = strDate.getTime();
        return new Timestamp(strTime);
    }

    public static Timestamp string2Timestamp(String str) {
        return DateUtil.string2Timestamp(str, DATE_PATTERN);
    }

    public static String timestamp2String(Timestamp date) {
        return DateUtil.timestamp2String(date, DATE_PATTERN);
    }

    public static String timestamp2String(Timestamp date, String format) {
        if (date == null) {
            return "";
        }
        return DateUtil.date2String(date, format);
    }

    public static Calendar string2Calender(String str) {
        if (str == null || str.length() < 14) {
            return null;
        }
        String year = str.substring(0, 4);
        String month = str.substring(4, 6);
        String day = str.substring(6, 8);
        String hour = str.substring(8, 10);
        String minute = str.substring(10, 12);
        String second = str.substring(12, 13);
        return new GregorianCalendar(StringUtil.string2integer(year), StringUtil.string2integer(month) - 1, StringUtil.string2integer(day), StringUtil.string2integer(hour), StringUtil.string2integer(minute), StringUtil.string2integer(second));
    }

    public static String calendar2String(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        return StringUtil.integer2string(year) + StringUtil.integer2string(month) + StringUtil.integer2string(day) + StringUtil.integer2string(hour) + StringUtil.integer2string(minute) + StringUtil.integer2string(second) + "000";
    }

    public static int getMinutes(Calendar cal1, Calendar cal2) {
        long utc1 = cal1.getTimeInMillis();
        long utc2 = cal2.getTimeInMillis();
        long result = (utc2 - utc1) / 60000L;
        return (int)result;
    }

    public static int getMinutes(String date1, String date2) {
        Calendar cal1 = DateUtil.string2Calender(date1);
        Calendar cal2 = DateUtil.string2Calender(date2);
        return DateUtil.getMinutes(cal1, cal2);
    }

    public static int getDays(Calendar cal1, Calendar cal2) {
        long min = DateUtil.getMinutes(cal1, cal2);
        return (int)(min / 1440L);
    }

    public static int getDays(String date1, String date2) {
        Calendar cal1 = DateUtil.string2Calender(date1);
        Calendar cal2 = DateUtil.string2Calender(date2);
        return DateUtil.getDays(cal1, cal2);
    }

    public static String getCurrentTime() {
        return DateUtil.getCurrentTime("yyyy-MM-dd HH:mm");
    }

    public static String getCurrentTime(String format) {
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(d);
    }

    public static String getCurrentDay() {
        return DateUtil.getCurrentTime(DATE_PATTERN);
    }

    public static String getThisMonth() {
        return DateUtil.getCurrentTime("yyyy-MM");
    }

    public static String getThisYear() {
        return DateUtil.getCurrentTime("yyyy");
    }

    public static String getCurrentHour() {
        return DateUtil.getCurrentTime("HH:mm");
    }

    public static String getYesterday() {
        return DateUtil.getYesterday(DATE_PATTERN);
    }

    public static String getYesterday(String format) {
        Calendar cal = DateUtil.getCalendar();
        cal.roll(5, -1);
        Date date = cal.getTime();
        return DateUtil.date2String(date, format);
    }

    public static String[] getDates(String startDay, String endDay) {
        return DateUtil.getDates(startDay, endDay, DATE_PATTERN);
    }

    public static String[] getDates(String startDay, String endDay, String format) {
        Vector<String> v = new Vector<String>();
        v.addElement(startDay);
        Calendar cal = DateUtil.getCalendar();
        cal.setTime(DateUtil.string2Date(startDay, format));
        String nextDay = DateUtil.date2String(cal.getTime(), format);
        while (!nextDay.equals(endDay)) {
            cal.add(5, 1);
            nextDay = DateUtil.date2String(cal.getTime(), format);
            v.addElement(nextDay);
        }
        Object[] go = new String[v.size()];
        v.copyInto(go);
        return go;
    }

    private static Calendar getCalendar() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT+09:00"), Locale.KOREA);
        calendar.setTime(new Date());
        return calendar;
    }
}

