/*
 * Decompiled with CFR 0.152.
 */
package anyframe.common.util;

import anyframe.common.exception.NestedRuntimeException;
import anyframe.common.util.DateUtil;
import anyframe.common.util.StringUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ObjectUtil {
    private static Log log = LogFactory.getLog((Class)ObjectUtil.class);
    private static Map classCache = new HashMap();

    private ObjectUtil() {
    }

    public static Class loadClass(String className) {
        return ObjectUtil.loadClass(className, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class loadClass(String className, ClassLoader loader) {
        Class<?> theClass;
        block11: {
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            try {
                theClass = loader.loadClass(className);
            }
            catch (Exception e) {
                theClass = (Class<?>)classCache.get(className);
                if (theClass != null) break block11;
                Class clazz = ObjectUtil.class;
                synchronized (clazz) {
                    theClass = (Class)classCache.get(className);
                    if (theClass == null || !classCache.containsValue(className)) {
                        try {
                            theClass = Class.forName(className);
                        }
                        catch (ClassNotFoundException e1) {
                            throw new NestedRuntimeException("Class is not found. [" + className + "]");
                        }
                        if (theClass != null) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Loaded Class: " + theClass.getName()));
                            }
                            classCache.put(className, theClass);
                        }
                    }
                }
            }
        }
        return theClass;
    }

    public static Object getObject(String className) {
        try {
            Class clazz = ObjectUtil.loadClass(className);
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(className + " : Class is cant instantialized."));
            }
            throw new NestedRuntimeException(className + " : Class is cant instantialized.");
        }
        catch (IllegalAccessException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(className + " : Class is not accessed."));
            }
            throw new NestedRuntimeException(className + " : Class is not accessed.");
        }
    }

    public static boolean isEmpty(Object bean) {
        if (bean == null) {
            return true;
        }
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors(bean.getClass());
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            String propertyName = propertyDescriptors[i].getName();
            Class<?> type = propertyDescriptors[i].getPropertyType();
            if (!type.getName().equals("java.lang.String") && !type.getName().equals("java.lang.Integer") && !type.getName().equals("java.lang.Long") && !type.getName().equals("java.lang.Double") && !type.getName().equals("java.util.Date")) continue;
            try {
                Object value = PropertyUtils.getProperty((Object)bean, (String)propertyName);
                if (value == null || value.equals("")) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)(propertyName + " : Class is not accessed."));
                }
                throw new NestedRuntimeException(propertyName + " : Class is not accessed.");
            }
            catch (InvocationTargetException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)(propertyName + " : Invocation error."));
                }
                throw new NestedRuntimeException(propertyName + " : Invocation error.");
            }
            catch (NoSuchMethodException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)(propertyName + " : Class has no such method."));
                }
                throw new NestedRuntimeException(propertyName + " : Class has no such method.");
            }
        }
        return true;
    }

    public static void copyProperties(Object destObj, Object origObj) {
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors(destObj.getClass());
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            Object origValue;
            String propertyName = propertyDescriptors[i].getName();
            Class<?> type = propertyDescriptors[i].getPropertyType();
            if ("class".equals(propertyName) || !ObjectUtil.hasProperty(origObj, propertyName)) continue;
            try {
                origValue = PropertyUtils.getProperty((Object)origObj, (String)propertyName);
            }
            catch (IllegalAccessException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)(propertyName + " : Class is not accessed."));
                }
                throw new NestedRuntimeException(propertyName + " : Class is not accessed.");
            }
            catch (InvocationTargetException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)(propertyName + " : Invocation error."));
                }
                throw new NestedRuntimeException(propertyName + " : Invocation error.");
            }
            catch (NoSuchMethodException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)(propertyName + " : Class has no such method."));
                }
                throw new NestedRuntimeException(propertyName + " : Class has no such method.");
            }
            ObjectUtil.setProperty(destObj, propertyName, origValue, type.getName());
        }
    }

    private static boolean hasProperty(Object bean, String propertyName) {
        try {
            Field field = bean.getClass().getDeclaredField(propertyName);
            if (field != null) {
                return true;
            }
        }
        catch (SecurityException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(propertyName + " : Class is not Security."));
            }
            throw new NestedRuntimeException(propertyName + " : Class is not Security.");
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        return false;
    }

    public static Object getProperty(Object object, String name) {
        try {
            return PropertyUtils.getProperty((Object)object, (String)name);
        }
        catch (IllegalAccessException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(name + " : Class is not accessed."));
            }
            throw new NestedRuntimeException(name + " : Class is not accessed.");
        }
        catch (InvocationTargetException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(name + " : Invocation error."));
            }
            throw new NestedRuntimeException(name + " : Invocation error.");
        }
        catch (NoSuchMethodException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(name + " : Class has no such method."));
            }
            throw new NestedRuntimeException(name + " : Class has no such method.");
        }
    }

    public static void setProperty(Object object, String name, Object value, String type) {
        String origType = null;
        if (value != null) {
            origType = value.getClass().getName();
            if (origType.indexOf("Date") != -1) {
                value = DateUtil.date2String((Date)value);
            }
            if (origType.indexOf("Timestamp") != -1) {
                value = DateUtil.timestamp2String((Timestamp)value);
            }
        }
        try {
            if (type.indexOf("String") != -1 && !ObjectUtil.isNull(value)) {
                PropertyUtils.setProperty((Object)object, (String)name, (Object)value.toString());
            } else if (type.indexOf("Long") != -1 && !ObjectUtil.isNull(value)) {
                value = new Long(value.toString());
                PropertyUtils.setProperty((Object)object, (String)name, (Object)value);
            } else if (type.indexOf("Integer") != -1 && !ObjectUtil.isNull(value)) {
                value = new Integer(value.toString());
                PropertyUtils.setProperty((Object)object, (String)name, (Object)value);
            } else if (type.indexOf("Double") != -1 && !ObjectUtil.isNull(value)) {
                value = new Double(value.toString());
                PropertyUtils.setProperty((Object)object, (String)name, (Object)value);
            } else if (type.indexOf("Date") != -1 && !ObjectUtil.isNull(value)) {
                value = DateUtil.string2Date((String)value);
                PropertyUtils.setProperty((Object)object, (String)name, (Object)value);
            }
        }
        catch (IllegalAccessException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(name + " : Class is not accessed."));
            }
            throw new NestedRuntimeException(name + " : Class is not accessed.");
        }
        catch (InvocationTargetException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(name + " : Invocation error."));
            }
            throw new NestedRuntimeException(name + " : Invocation error.");
        }
        catch (NoSuchMethodException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(name + " : Class has no such method."));
            }
            throw new NestedRuntimeException(name + " : Class has no such method.");
        }
    }

    public static void setProperty(Object object, String name, Object value) {
        try {
            PropertyUtils.setProperty((Object)object, (String)name, (Object)value);
        }
        catch (IllegalAccessException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(name + " : Class is not accessed."));
            }
            throw new NestedRuntimeException(name + " : Class is not accessed.");
        }
        catch (InvocationTargetException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(name + " : Invocation error."));
            }
            throw new NestedRuntimeException(name + " : Invocation error.");
        }
        catch (NoSuchMethodException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(name + " : Class has no such method."));
            }
            throw new NestedRuntimeException(name + " : Class has no such method.");
        }
    }

    public static Field getField(Object object, String fieldName) {
        Field field = null;
        try {
            field = object.getClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(fieldName + " : Class has no such Field." + e.toString()));
            }
            throw new NestedRuntimeException(fieldName + " : Class has no such field.");
        }
        return field;
    }

    public static Method getMethod(Object object, String methodName, Class[] argClasses) {
        Method method;
        block4: {
            method = null;
            try {
                method = object.getClass().getDeclaredMethod(methodName, argClasses);
            }
            catch (SecurityException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)(methodName + " : Security!" + e.toString()));
                }
            }
            catch (NoSuchMethodException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)(methodName + " : Class has no such method." + e.toString()));
            }
        }
        return method;
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static Object getModel(Object formObject) {
        String className = (String)ObjectUtil.getProperty(formObject, "className");
        Object destObj = ObjectUtil.getObject(className);
        if (destObj != null) {
            ObjectUtil.copyProperties(destObj, formObject);
        }
        return destObj;
    }

    public static void addProperty(Object destObject, String property, Object value) {
        String methodName = "add" + StringUtil.swapFirstLetterCase(property);
        Class[] classes = new Class[]{value.getClass()};
        Method method = ObjectUtil.getMethod(destObject, methodName, classes);
        try {
            method.invoke(destObject, value);
        }
        catch (IllegalArgumentException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Argument is illegal.");
            }
            throw new NestedRuntimeException("Argument is illegal.");
        }
        catch (IllegalAccessException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(property + " : Class is not accessed."));
            }
            throw new NestedRuntimeException(property + " : Class is not accessed.");
        }
        catch (InvocationTargetException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(property + " : Invocation error."));
            }
            throw new NestedRuntimeException(property + " : Invocation error.");
        }
    }
}

