/*
 * Decompiled with CFR 0.152.
 */
package anyframe.common.util;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public abstract class StringUtil {
    private static Log log = LogFactory.getLog((Class)StringUtil.class);

    private StringUtil() {
    }

    public static String encodePassword(String password, String algorithm) {
        byte[] unencodedPassword = password.getBytes();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e));
            return password;
        }
        md.reset();
        md.update(unencodedPassword);
        byte[] encodedPassword = md.digest();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < encodedPassword.length; ++i) {
            if ((encodedPassword[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(encodedPassword[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static String encodeString(String str) {
        BASE64Encoder encoder = new BASE64Encoder();
        return new String(encoder.encodeBuffer(str.getBytes())).trim();
    }

    public static String decodeString(String str) {
        BASE64Decoder dec = new BASE64Decoder();
        try {
            return new String(dec.decodeBuffer(str));
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io.getCause());
        }
    }

    public static String swapFirstLetterCase(String str) {
        StringBuffer sbuf = new StringBuffer(str);
        sbuf.deleteCharAt(0);
        if (Character.isLowerCase(str.substring(0, 1).toCharArray()[0])) {
            sbuf.insert(0, str.substring(0, 1).toUpperCase());
        } else {
            sbuf.insert(0, str.substring(0, 1).toLowerCase());
        }
        return sbuf.toString();
    }

    public static String trim(String origString, String trimString) {
        int startPosit = origString.indexOf(trimString);
        if (startPosit != -1) {
            int endPosit = trimString.length() + startPosit;
            return origString.substring(0, startPosit) + origString.substring(endPosit);
        }
        return origString;
    }

    public static String getLastString(String origStr, String strToken) {
        StringTokenizer str = new StringTokenizer(origStr, strToken);
        String lastStr = "";
        while (str.hasMoreTokens()) {
            lastStr = str.nextToken();
        }
        return lastStr;
    }

    public static String[] getStringArray(String str, String strToken) {
        if (str.indexOf(strToken) != -1) {
            StringTokenizer st = new StringTokenizer(str, strToken);
            String[] stringArray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                stringArray[i] = st.nextToken();
                ++i;
            }
            return stringArray;
        }
        return new String[]{str};
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String replace(String str, String replacedStr, String replaceStr) {
        String newStr = "";
        if (str.indexOf(replacedStr) != -1) {
            String s1 = str.substring(0, str.indexOf(replacedStr));
            String s2 = str.substring(str.indexOf(replacedStr) + 1);
            newStr = s1 + replaceStr + s2;
        }
        return newStr;
    }

    public static int string2integer(String str) {
        int ret = Integer.parseInt(str.trim());
        return ret;
    }

    public static String integer2string(int integer) {
        return "" + integer;
    }

    public static boolean isPatternMatching(String str, String pattern) throws Exception {
        if (pattern.indexOf(42) >= 0) {
            pattern = pattern.replaceAll("\\*", ".*");
        }
        pattern = "^" + pattern + "$";
        return Pattern.matches(pattern, str);
    }

    public static boolean containsMaxSequence(String str, String maxSeqNumber) {
        int occurence = 1;
        int max = StringUtil.string2integer(maxSeqNumber);
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz - 1; ++i) {
            if (str.charAt(i) == str.charAt(i + 1)) {
                if (++occurence != max) continue;
                return true;
            }
            occurence = 1;
        }
        return false;
    }

    public static boolean containsInvalidChars(String str, char[] invalidChars) {
        if (str == null || invalidChars == null) {
            return false;
        }
        int strSize = str.length();
        int validSize = invalidChars.length;
        for (int i = 0; i < strSize; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < validSize; ++j) {
                if (invalidChars[j] != ch) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsInvalidChars(String str, String invalidChars) {
        if (str == null || invalidChars == null) {
            return true;
        }
        return StringUtil.containsInvalidChars(str, invalidChars.toCharArray());
    }

    public static boolean isAlphaNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        if (sz == 0) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetterOrDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        if (sz == 0) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        if (sz == 0) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuffer(str).reverse().toString();
    }

    public static String fillString(String originalStr, char ch, int cipers) {
        int originalStrLength = originalStr.length();
        if (cipers < originalStrLength) {
            return null;
        }
        int difference = cipers - originalStrLength;
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < difference; ++i) {
            strBuf.append(ch);
        }
        strBuf.append(originalStr);
        return strBuf.toString();
    }

    public static final boolean isEmptyTrimmed(String foo) {
        return foo == null || foo.trim().length() == 0;
    }

    public static List getTokens(String lst, String separator) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (lst != null) {
            StringTokenizer st = new StringTokenizer(lst, separator);
            while (st.hasMoreTokens()) {
                try {
                    String en = st.nextToken().trim();
                    tokens.add(en);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return tokens;
    }

    public static List getTokens(String lst) {
        return StringUtil.getTokens(lst, ",");
    }

    public static String convertToCamelCase(String targetString, char posChar) {
        StringBuffer result = new StringBuffer();
        boolean nextUpper = false;
        String allLower = targetString.toLowerCase();
        for (int i = 0; i < allLower.length(); ++i) {
            char currentChar = allLower.charAt(i);
            if (currentChar == posChar) {
                nextUpper = true;
                continue;
            }
            if (nextUpper) {
                currentChar = Character.toUpperCase(currentChar);
                nextUpper = false;
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    public static String convertToCamelCase(String underScore) {
        return StringUtil.convertToCamelCase(underScore, '_');
    }

    public static String convertToUnderScore(String camelCase) {
        String result = "";
        for (int i = 0; i < camelCase.length(); ++i) {
            char currentChar = camelCase.charAt(i);
            if (i > 0 && Character.isUpperCase(currentChar)) {
                result = result.concat("_");
            }
            result = result.concat(Character.toString(currentChar).toLowerCase());
        }
        return result;
    }

    public static String null2str(String org, String converted) {
        if (org == null || org.trim().length() == 0) {
            return converted;
        }
        return org.trim();
    }

    public static String null2str(String org) {
        return StringUtil.null2str(org, "");
    }
}

