/*
 * Decompiled with CFR 0.152.
 */
package anyframe.common.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class GrepFile {
    private static Charset charset = Charset.forName("ISO-8859-15");
    private static CharsetDecoder decoder = charset.newDecoder();

    private GrepFile() {
    }

    public static boolean containsPattern(File file, Pattern pattern) throws IOException {
        Matcher pm = pattern.matcher(file.getName());
        return pm.find();
    }

    public static String[] findPattern(File file, Pattern pattern, int group) throws IOException {
        ArrayList<String> occurences = new ArrayList<String>();
        FileInputStream fis = new FileInputStream(file);
        FileChannel fc = fis.getChannel();
        int sz = (int)fc.size();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
        CharBuffer cb = decoder.decode(bb);
        Matcher pm = pattern.matcher(cb);
        while (pm.find()) {
            occurences.add(pm.group(group));
        }
        fc.close();
        fis.close();
        return occurences.toArray(new String[occurences.size()]);
    }

    private static List findInternal(File file, Pattern pattern) throws IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        if (file.isDirectory()) {
            String[] children = file.list();
            for (int i = 0; i < children.length; ++i) {
                fileList.addAll(GrepFile.findInternal(new File(file.getAbsolutePath(), children[i]), pattern));
            }
        } else if (file.isFile() && GrepFile.containsPattern(file, pattern)) {
            fileList.add(file);
        }
        return fileList;
    }

    private static List findInternalWithDirectory(File file, Pattern pattern) throws IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        if (file.isDirectory()) {
            fileList.add(file);
            String[] children = file.list();
            for (int i = 0; i < children.length; ++i) {
                fileList.addAll(GrepFile.findInternalWithDirectory(new File(file.getAbsolutePath(), children[i]), pattern));
            }
        } else if (file.isFile() && GrepFile.containsPattern(file, pattern)) {
            fileList.add(file);
        }
        return fileList;
    }

    public static File[] find(File file, String searchString) throws IOException {
        Pattern pattern = Pattern.compile(searchString);
        List fileList = GrepFile.findInternal(file, pattern);
        return fileList.toArray(new File[fileList.size()]);
    }

    public static File[] find(File file, String searchString, boolean containsDirectory) throws IOException {
        Pattern pattern = Pattern.compile(searchString);
        List fileList = containsDirectory ? GrepFile.findInternalWithDirectory(file, pattern) : GrepFile.findInternal(file, pattern);
        return fileList.toArray(new File[fileList.size()]);
    }
}

