/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.properties.impl;

import anyframe.common.exception.BaseException;
import anyframe.common.exception.NestedRuntimeException;
import anyframe.core.properties.IPropertiesService;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.collections.ExtendedProperties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public abstract class PropertiesServiceImpl
implements IPropertiesService,
ApplicationContextAware,
Configurable,
InitializingBean,
DisposableBean,
ResourceLoaderAware {
    private ExtendedProperties anyframeProperties = null;
    private ResourceLoader resourceLoader = null;
    Configuration configuration;
    private MessageSource messageSource;

    public abstract void setConfiguration(Configuration var1);

    public boolean getBoolean(String name) {
        return this.getConfiguration().getBoolean(name);
    }

    public boolean getBoolean(String name, boolean def) {
        return this.getConfiguration().getBoolean(name, def);
    }

    public double getDouble(String name) {
        return this.getConfiguration().getDouble(name);
    }

    public double getDouble(String name, double def) {
        return this.getConfiguration().getDouble(name, def);
    }

    public float getFloat(String name) {
        return this.getConfiguration().getFloat(name);
    }

    public float getFloat(String name, float def) {
        return this.getConfiguration().getFloat(name, def);
    }

    public int getInt(String name) {
        return this.getConfiguration().getInt(name);
    }

    public int getInt(String name, int def) {
        return this.getConfiguration().getInt(name, def);
    }

    public Iterator getKeys() {
        return this.getConfiguration().getKeys();
    }

    public Iterator getKeys(String prefix) {
        return this.getConfiguration().getKeys(prefix);
    }

    public long getLong(String name) {
        return this.getConfiguration().getLong(name);
    }

    public long getLong(String name, long def) {
        return this.getConfiguration().getLong(name, def);
    }

    public String getString(String name) {
        return this.getConfiguration().getString(name);
    }

    public String getString(String name, String def) {
        return this.getConfiguration().getString(name, def);
    }

    public String[] getStringArray(String name) {
        return this.getConfiguration().getStringArray(name);
    }

    public Vector getVector(String name) {
        return this.getConfiguration().getVector(name);
    }

    public Vector getVector(String name, Vector def) {
        return this.getConfiguration().getVector(name, def);
    }

    private ExtendedProperties getConfiguration() {
        return this.anyframeProperties;
    }

    public void refreshPropertyFiles() {
        String fileName = null;
        try {
            Configuration[] configs = this.configuration.getChildren();
            for (int i = 0; i < configs.length; ++i) {
                fileName = configs[i].getName();
                if (!"fileName".equals(fileName)) continue;
                String enc = configs[i].getAttribute("encoding", null);
                this.loadPropertiesDefinition(configs[i].getValue(), enc);
            }
        }
        catch (Exception e) {
            if (IPropertiesService.LOGGER.isErrorEnabled()) {
                IPropertiesService.LOGGER.error((Object)this.messageSource.getMessage("error.properties.refresh.files", (Object[])new String[]{fileName}, Locale.getDefault()));
                IPropertiesService.LOGGER.error((Object)this.messageSource.getMessage("error.properties.refresh.files.reason", (Object[])new String[0], Locale.getDefault()));
            }
            throw new NestedRuntimeException("error.properties.refresh.files", (Object[])new String[]{fileName}, (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws BaseException {
        try {
            this.anyframeProperties = new ExtendedProperties();
            Configuration[] configs = this.configuration.getChildren();
            for (int i = 0; i < configs.length; ++i) {
                if (!"fileName".equals(configs[i].getName())) continue;
                String enc = configs[i].getAttribute("encoding", null);
                this.loadPropertiesDefinition(configs[i].getValue(), enc);
            }
            Configuration properties = this.configuration.getChild("properties");
            Configuration[] property = properties.getChildren();
            for (int i = 0; i < property.length; ++i) {
                String key = property[i].getAttribute("key", "");
                String value = property[i].getAttribute("value", "");
                if (IPropertiesService.LOGGER.isDebugEnabled()) {
                    IPropertiesService.LOGGER.debug((Object)this.messageSource.getMessage("debug.properties.property", (Object[])new String[]{key, value}, Locale.getDefault()));
                }
                if (key.equals("")) {
                    if (IPropertiesService.LOGGER.isErrorEnabled()) {
                        IPropertiesService.LOGGER.error((Object)this.messageSource.getMessage("error.properties.check.essential", (Object[])new String[0], Locale.getDefault()));
                    }
                    throw new BaseException(this.messageSource, "error.properties.check.essential");
                }
                this.anyframeProperties.put((Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            if (IPropertiesService.LOGGER.isErrorEnabled()) {
                IPropertiesService.LOGGER.error((Object)this.messageSource.getMessage("error.properties.initialize.reason", (Object[])new String[0], Locale.getDefault()));
            }
            throw new BaseException(this.messageSource, "error.properties.initialize", (Throwable)e);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    public void destroy() {
        this.anyframeProperties = new ExtendedProperties();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.messageSource = (MessageSource)applicationContext.getBean("messageSource");
    }

    private void loadPropertiesDefinition(String location, String encoding) throws Exception {
        if (this.resourceLoader instanceof ResourcePatternResolver) {
            try {
                Resource[] resources = ((ResourcePatternResolver)this.resourceLoader).getResources(location);
                this.loadPropertiesDefinitions(resources, encoding);
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("Could not resolve Properties resource pattern [" + location + "]", (Throwable)ex);
            }
        } else {
            Resource resource = this.resourceLoader.getResource(location);
            this.loadPropertiesDefinition(resource, encoding);
        }
    }

    private void loadPropertiesDefinitions(Resource[] resources, String encoding) throws Exception {
        Assert.notNull((Object)resources, (String)"Resource array must not be null");
        for (int i = 0; i < resources.length; ++i) {
            this.loadPropertiesDefinition(resources[i], encoding);
        }
    }

    private void loadPropertiesDefinition(Resource resource, String encoding) throws Exception {
        if (IPropertiesService.LOGGER.isDebugEnabled()) {
            IPropertiesService.LOGGER.debug((Object)this.messageSource.getMessage("debug.properties.filename", (Object[])new String[]{resource.getFilename(), encoding}, Locale.getDefault()));
        }
        ExtendedProperties anyframeProperty = new ExtendedProperties();
        anyframeProperty.load(resource.getInputStream(), encoding);
        this.anyframeProperties.putAll((Map)anyframeProperty);
    }
}

