/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent;

import net.sf.infrared.agent.ChildTimeTracker;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class ChildTimeTrackerImpl
implements ChildTimeTracker {
    private static final int INITIAL_SIZE = 25;
    private static final int GROW_BY = 6;
    private static final Logger log = LoggingFactory.getLogger(ChildTimeTrackerImpl.class);
    private long[] childTimes = null;
    private int capacity = 0;
    private int top = 0;

    public void begin() {
        if (this.top >= this.capacity) {
            this.growArray();
        }
        this.childTimes[this.top++] = 0L;
    }

    public void recordChildExecutionTime(long time) {
        if (this.top > 1) {
            int n = this.top - 2;
            this.childTimes[n] = this.childTimes[n] + time;
        }
    }

    public long getChildExecutionTime() {
        if (this.top > 0) {
            return this.childTimes[this.top - 1];
        }
        if (log.isDebugEnabled()) {
            log.debug("Mismatch in being/end calls");
        }
        return 0L;
    }

    public void end() {
        if (this.top > 0) {
            --this.top;
        }
        this.shrinkIfRequired();
    }

    public void reset() {
        this.top = 0;
        this.shrinkIfRequired();
    }

    private void shrinkIfRequired() {
        if (this.capacity > 25 && this.capacity - this.top > 12) {
            if (log.isInfoEnabled()) {
                log.info("Shrinking array capacity " + this.capacity + " top " + this.top);
            }
            long[] temp = this.childTimes;
            this.capacity -= 6;
            this.childTimes = new long[this.capacity];
            for (int i = 0; i < this.top; ++i) {
                this.childTimes[i] = temp[i];
            }
        }
    }

    private void growArray() {
        if (this.capacity > 0) {
            long[] temp = this.childTimes;
            this.childTimes = new long[this.capacity + 6];
            for (int i = 0; i < temp.length; ++i) {
                this.childTimes[i] = temp[i];
            }
            this.capacity += 6;
            if (log.isInfoEnabled()) {
                log.info("Growing array by 6 capacity " + this.capacity + " top " + this.top);
            }
        } else {
            this.childTimes = new long[25];
            this.capacity = 25;
            if (log.isInfoEnabled()) {
                log.info("Initizliaing array with initial size 25");
            }
        }
    }
}

