/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.infrared.agent.util.MutableInteger;
import net.sf.infrared.base.model.ExecutionTimer;
import net.sf.infrared.base.model.LayerTime;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class LayerTimeTracker {
    private static final Logger log;
    private static final String LAYER_SEPARATOR = ".";
    private static final int LAYER_PATH_INITIAL_SIZE = 256;
    private Map layerTimings = new HashMap();
    private Map layerCount = new HashMap();
    private StringBuffer layerPath = new StringBuffer(256);
    private long pruneThreshold = -1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void enterLayer(ExecutionTimer et) {
        String layer = et.getContext().getLayer();
        this.enterLayer(layer);
    }

    public boolean leaveLayer(ExecutionTimer et) {
        String layer = et.getContext().getLayer();
        return this.leaveLayer(layer, et.getInclusiveTime());
    }

    public Map reset(boolean isFaulty) {
        Map oldLayerTimings = this.layerTimings;
        this.layerTimings = new HashMap();
        if (isFaulty) {
            this.layerCount.clear();
            this.layerPath = new StringBuffer(256);
        }
        return oldLayerTimings;
    }

    public Map getLayerTimings() {
        return Collections.unmodifiableMap(this.layerTimings);
    }

    public String toString() {
        return "LayerTimeTracker for thread " + Thread.currentThread();
    }

    public String getCurrentLayer() {
        return this.layerPath.toString().intern();
    }

    void enterLayer(String layer) {
        MutableInteger currentCount = this.getLayerCount(layer);
        if (currentCount.isZero()) {
            this.addLayerToPath(layer);
        }
        currentCount.increment();
        if (log.isDebugEnabled()) {
            log.debug(this + " - Entered layer " + layer + " for the " + currentCount + "-th time");
        }
    }

    boolean leaveLayer(String layer, long time) {
        MutableInteger currentCount = this.getLayerCount(layer);
        if (!$assertionsDisabled && !currentCount.isPositive()) {
            throw new AssertionError((Object)(this + " - Mistmatch in Enter/Leave layer. Count should be +ve, was " + currentCount));
        }
        currentCount.decrement();
        if (currentCount.isZero()) {
            this.addTimeToLayer(this.getCurrentLayer(), time);
            this.removeLayerFromPath();
        }
        return true;
    }

    long getPruneBelowTime() {
        return this.pruneThreshold;
    }

    void setPruneBelowTime(long time) {
        this.pruneThreshold = time;
    }

    private MutableInteger getLayerCount(String layer) {
        MutableInteger count = (MutableInteger)this.layerCount.get(layer);
        if (count == null) {
            count = new MutableInteger(0);
            this.layerCount.put(layer, count);
        }
        return count;
    }

    private void addLayerToPath(String layer) {
        if (this.layerPath.length() > 0) {
            this.layerPath.append(LAYER_SEPARATOR);
        }
        this.layerPath.append(layer);
    }

    private void addTimeToLayer(String layer, long executionTime) {
        if (executionTime <= this.getPruneBelowTime()) {
            if (log.isDebugEnabled()) {
                log.debug("Discarded tracking of layer " + layer + " because the time (" + executionTime + ") <= prune threshold (" + this.getPruneBelowTime() + ")");
            }
            return;
        }
        LayerTime layerTime = (LayerTime)this.layerTimings.get(layer);
        if (layerTime == null) {
            layerTime = new LayerTime(layer);
            this.layerTimings.put(layer, layerTime);
        }
        layerTime.addToTime(executionTime);
        if (log.isDebugEnabled()) {
            log.debug(this + " - Adding " + executionTime + " to layer " + layer);
        }
    }

    private void removeLayerFromPath() {
        if (this.layerPath.lastIndexOf(LAYER_SEPARATOR) > -1) {
            this.layerPath.delete(this.layerPath.lastIndexOf(LAYER_SEPARATOR), this.layerPath.length());
        } else {
            this.layerPath.delete(0, this.layerPath.length());
        }
    }

    static {
        $assertionsDisabled = !LayerTimeTracker.class.desiredAssertionStatus();
        log = LoggingFactory.getLogger(LayerTimeTracker.class);
    }
}

