/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.infrared.agent.MonitorConfig;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class MonitorConfigImpl
implements MonitorConfig {
    public static final String DEFAULT_CONFIG_LOCATION = "infrared-agent.properties";
    private static final Logger log = LoggingFactory.getLogger(MonitorConfigImpl.class);
    private static final String KEY_ENABLE_MONITORING = "enable-monitoring";
    private static final String KEY_ENABLE_CALL_TRACING = "enable-call-tracing";
    private static final String KEY_PRUNE_THRESHOLD = "prune-threshold";
    private static final String KEY_LAST_INVOCATIONS_COUNT = "last-invocations-to-trace";
    private static final String KEY_COLLECTION_STRATEGY = "collection-strategy";
    private static final boolean DEFAULT_ENABLE_MONITORING = false;
    private static final Boolean DEFAULT_ENABLE_MONITORING_FOR_CURRENT_THREAD = Boolean.TRUE;
    private static final boolean DEFAULT_ENABLE_CALL_TRACING = false;
    private static final long DEFAULT_PRUNE_THRESHOLD = 50L;
    private static final int DEFAULT_LAST_INVOCATIONS_COUNT = 5;
    private static final String DEFAULT_COLLECTION_STRATEGY = "net.sf.infrared.agent.transport.impl.LoggingCollectionStrategy";
    private Properties rawProps;
    private Map parsedProps = new HashMap();
    private URL cfg;
    private boolean isCallFromInfraredPropertiesMBean = false;
    private ThreadLocal isMonitoringOnForCurrentThread = new ThreadLocal(){

        protected Object initialValue() {
            return DEFAULT_ENABLE_MONITORING_FOR_CURRENT_THREAD;
        }
    };
    private static final String TRUE = "true".intern();
    private static final String FALSE = "false".intern();

    public MonitorConfigImpl() {
        this(DEFAULT_CONFIG_LOCATION);
    }

    public MonitorConfigImpl(String cfgLocation) {
        this.rawProps = new Properties();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            this.cfg = loader.getResource(cfgLocation);
            this.rawProps.load(this.cfg.openStream());
        }
        catch (Throwable th) {
            log.fatal("Error loading configuration from " + cfgLocation + ". Using defaults for all configuration", th);
        }
    }

    MonitorConfigImpl(Properties props) {
        this.rawProps = props;
    }

    public boolean isMonitoringEnabled() {
        return this.getProperty(KEY_ENABLE_MONITORING, false);
    }

    public void enableMonitoring(boolean enable) {
        this.setProperty(KEY_ENABLE_MONITORING, enable);
    }

    public boolean isMonitoringEnabledForCurrentThread() {
        Boolean b = (Boolean)this.isMonitoringOnForCurrentThread.get();
        return b;
    }

    public void enableMonitoringForCurrentThread(boolean enable) {
        this.isMonitoringOnForCurrentThread.set(enable);
    }

    public boolean isCallTracingEnabled() {
        return this.getProperty(KEY_ENABLE_CALL_TRACING, false);
    }

    public void enableCallTracing(boolean enable) {
        this.setProperty(KEY_ENABLE_CALL_TRACING, enable);
    }

    public long getPruneThreshold() {
        return this.getProperty(KEY_PRUNE_THRESHOLD, 50L);
    }

    public void setPruneThreshold(long pruneThreshold) {
        this.setProperty(KEY_PRUNE_THRESHOLD, pruneThreshold);
    }

    public int getNoOfLastInvocationsToBeTracked() {
        return this.getProperty(KEY_LAST_INVOCATIONS_COUNT, 5);
    }

    public void setNoOfLastInvocationsToBeTracked(int n) {
        this.setProperty(KEY_LAST_INVOCATIONS_COUNT, n);
    }

    public String getCollectionStrategy() {
        return this.getProperty(KEY_COLLECTION_STRATEGY, DEFAULT_COLLECTION_STRATEGY);
    }

    public String getProperty(String propertyName, String defaultValue) {
        return this.rawProps.getProperty(propertyName, defaultValue);
    }

    public void setProperty(String propertyName, String value) {
        this.rawProps.setProperty(propertyName, value);
        this.parsedProps.remove(propertyName);
    }

    public int getProperty(String propertyName, int defaultValue) {
        Integer in = (Integer)this.parsedProps.get(propertyName);
        if (in != null) {
            return in;
        }
        String value = this.getProperty(propertyName);
        if (value == null) {
            return defaultValue;
        }
        int i = defaultValue;
        try {
            i = Integer.parseInt(value);
            this.parsedProps.put(propertyName, new Integer(i));
        }
        catch (NumberFormatException e) {
            log.error("Failed to parse value " + value + " for property " + propertyName + " to integer, using default " + defaultValue);
        }
        return i;
    }

    public void setProperty(String propertyName, int value) {
        this.setProperty(propertyName, Integer.toString(value));
    }

    public long getProperty(String propertyName, long defaultValue) {
        Long lo = (Long)this.parsedProps.get(propertyName);
        if (lo != null) {
            return lo;
        }
        String value = this.getProperty(propertyName);
        if (value == null) {
            return defaultValue;
        }
        long l = defaultValue;
        try {
            l = Long.parseLong(value);
            this.parsedProps.put(propertyName, new Long(l));
        }
        catch (NumberFormatException e) {
            log.error("Failed to parse value " + value + " for property " + propertyName + " to long, using default " + defaultValue);
        }
        return l;
    }

    public void setProperty(String propertyName, long value) {
        this.setProperty(propertyName, Long.toString(value));
    }

    public boolean getProperty(String propertyName, boolean defaultValue) {
        Boolean bo = (Boolean)this.parsedProps.get(propertyName);
        if (bo != null) {
            return bo;
        }
        String value = this.getProperty(propertyName);
        if (value == null) {
            return defaultValue;
        }
        if (TRUE == (value = value.trim().intern())) {
            this.parsedProps.put(propertyName, Boolean.TRUE);
            return true;
        }
        if (FALSE == value) {
            this.parsedProps.put(propertyName, Boolean.FALSE);
            return false;
        }
        log.error("Failed to parse value " + value + " for property " + propertyName + " to boolean, using default " + defaultValue);
        return defaultValue;
    }

    public void setProperty(String propertyName, boolean value) {
        this.setProperty(propertyName, Boolean.toString(value));
    }

    public String toString() {
        return "MonitorConfig[" + this.cfg + "]";
    }

    private String getProperty(String propertyName) {
        return this.rawProps.getProperty(propertyName);
    }
}

