/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent;

import net.sf.infrared.agent.MonitorConfig;
import net.sf.infrared.agent.MonitorFacade;
import net.sf.infrared.agent.StatisticsCollector;
import net.sf.infrared.agent.transport.CollectionStrategy;
import net.sf.infrared.agent.transport.impl.DoNothingCollectionStrategy;
import net.sf.infrared.base.model.ExecutionTimer;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class MonitorFacadeImpl
implements MonitorFacade {
    public static final String KEY_PRINT_FACADE_CREATION = "infrared.print.applications";
    private static final Logger log = LoggingFactory.getLogger(MonitorFacadeImpl.class);
    private ThreadLocal statisticsCollector;
    private CollectionStrategy collectionStrategy;
    private String applicationName;
    private String instanceId;
    private MonitorConfig configuration;

    public MonitorFacadeImpl(String applicationName, String instanceId, MonitorConfig config, boolean print) {
        this(applicationName, instanceId, config);
        if (print && Boolean.getBoolean(KEY_PRINT_FACADE_CREATION)) {
            System.out.println("[InfraRED] Created MonitorFacade for " + applicationName + ", instance " + instanceId + ", with config " + config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitorFacadeImpl(String applicationName, String instanceId, MonitorConfig config) {
        block14: {
            this.statisticsCollector = new ThreadLocal(){

                protected synchronized Object initialValue() {
                    if (log.isDebugEnabled()) {
                        log.debug("Initializing statistics collector for thread " + Thread.currentThread() + "\n" + "\t collectionStratergy = " + MonitorFacadeImpl.this.collectionStrategy + "\n" + "\t applicationName = " + MonitorFacadeImpl.this.applicationName + "\n" + "\t instanceId = " + MonitorFacadeImpl.this.instanceId);
                    }
                    return new StatisticsCollector(MonitorFacadeImpl.this.collectionStrategy, MonitorFacadeImpl.this.applicationName, MonitorFacadeImpl.this.instanceId, MonitorFacadeImpl.this.configuration);
                }
            };
            this.collectionStrategy = null;
            if (log.isDebugEnabled()) {
                log.debug("Creating MonitorFacadeImpl for application " + applicationName + ", instance " + instanceId);
            }
            this.applicationName = applicationName;
            this.instanceId = instanceId;
            this.configuration = config;
            if (log.isDebugEnabled()) {
                log.debug("Collection stategy for application " + applicationName + ", instance " + instanceId + " is " + config.getCollectionStrategy());
            }
            try {
                try {
                    Class<?> collectionStrategyClass = Class.forName(config.getCollectionStrategy());
                    this.collectionStrategy = (CollectionStrategy)collectionStrategyClass.newInstance();
                    this.collectionStrategy.init(config);
                }
                catch (ClassNotFoundException e) {
                    log.error("Error creating MonitorFacadeImpl for application " + applicationName + ", instance " + instanceId, e);
                    Object var6_9 = null;
                    if (this.collectionStrategy == null) {
                        this.collectionStrategy = new DoNothingCollectionStrategy();
                    }
                    break block14;
                }
                catch (InstantiationException e) {
                    log.error("Error creating MonitorFacadeImpl for application " + applicationName + ", instance " + instanceId, e);
                    Object var6_10 = null;
                    if (this.collectionStrategy == null) {
                        this.collectionStrategy = new DoNothingCollectionStrategy();
                    }
                    break block14;
                }
                catch (IllegalAccessException e) {
                    log.error("Error creating MonitorFacadeImpl for application " + applicationName + ", instance " + instanceId, e);
                    Object var6_11 = null;
                    if (this.collectionStrategy == null) {
                        this.collectionStrategy = new DoNothingCollectionStrategy();
                    }
                }
                Object var6_8 = null;
                if (this.collectionStrategy == null) {
                    this.collectionStrategy = new DoNothingCollectionStrategy();
                }
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                if (this.collectionStrategy == null) {
                    this.collectionStrategy = new DoNothingCollectionStrategy();
                }
                throw throwable;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Created MonitorFacadeImpl for application " + applicationName + ", instance " + instanceId + " with configuration " + config);
        }
    }

    public StatisticsCollector recordExecutionBegin(ExecutionTimer timer) {
        StatisticsCollector collector = this.getStatisticsCollectorOfThisThread();
        collector.recordExecutionBegin(timer);
        return collector;
    }

    public void recordExecutionEnd(ExecutionTimer timer) {
        this.recordExecutionEnd(timer, this.getStatisticsCollectorOfThisThread());
    }

    public void recordExecutionEnd(ExecutionTimer timer, StatisticsCollector collector) {
        collector.recordExecutionEnd(timer);
    }

    public boolean isMonitoringEnabled() {
        return this.getConfiguration().isMonitoringEnabled() && this.getConfiguration().isMonitoringEnabledForCurrentThread();
    }

    public MonitorConfig getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return "MonitorFacadeImpl (app = " + this.applicationName + ", instance = " + this.instanceId + ")";
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void destroy() {
        this.collectionStrategy.destroy();
    }

    CollectionStrategy getCollectionStrategy() {
        return this.collectionStrategy;
    }

    StatisticsCollector getStatisticsCollectorOfThisThread() {
        return (StatisticsCollector)this.statisticsCollector.get();
    }
}

