/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.infrared.agent.MonitorConfigImpl;
import net.sf.infrared.agent.MonitorFacade;
import net.sf.infrared.agent.MonitorFacadeImpl;
import net.sf.infrared.agent.MultipleEntryGuard;
import net.sf.infrared.agent.util.AgentHelper;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class MonitorFactory {
    public static final String DEFAULT_CONFIG_LOCATION = "infrared-agent-root.properties";
    private static Logger log;
    private static Map classLoaderToMonitorFacadeMap;
    private static MonitorFacade defaultFacade;

    public static MonitorFacade getFacade() {
        ClassLoader loaderForThisApp = Thread.currentThread().getContextClassLoader();
        MonitorFacade facade = MonitorFactory.getFacadeImplForCurrentApplication(loaderForThisApp);
        if (facade == null) {
            facade = defaultFacade;
        }
        return facade;
    }

    public static void registerFacadeImpl(MonitorFacade facade) {
        MonitorFactory.registerFacadeImpl(facade, Thread.currentThread().getContextClassLoader());
    }

    public static void registerFacadeImpl(MonitorFacade facade, ClassLoader loader) {
        classLoaderToMonitorFacadeMap.put(loader, facade);
        if (log.isDebugEnabled()) {
            log.debug("Registered " + facade);
        }
    }

    public static void unregisterFacadeImpl(MonitorFacade facade) {
        Iterator i = classLoaderToMonitorFacadeMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getValue() != facade) continue;
            classLoaderToMonitorFacadeMap.remove(entry.getKey());
        }
        if (log.isDebugEnabled()) {
            log.debug("Unregistered " + facade);
        }
    }

    public static MonitorFacade unregisterFacadeImpl() {
        MonitorFacade removedFacade = null;
        removedFacade = (MonitorFacade)classLoaderToMonitorFacadeMap.remove(Thread.currentThread().getContextClassLoader());
        if (log.isDebugEnabled()) {
            log.debug("UnRegistered " + removedFacade);
        }
        return removedFacade;
    }

    public static void reset() {
        classLoaderToMonitorFacadeMap.clear();
    }

    public static MonitorFacade getDefaultFacade() {
        return defaultFacade;
    }

    private static MonitorFacade getFacadeImplForCurrentApplication(ClassLoader loader) {
        ClassLoader parent;
        MonitorFacade facade = (MonitorFacade)classLoaderToMonitorFacadeMap.get(loader);
        if (facade == null && (parent = loader.getParent()) != null) {
            facade = MonitorFactory.getFacadeImplForCurrentApplication(parent);
        }
        return facade;
    }

    private static void init() {
        try {
            log = LoggingFactory.getLogger(MonitorFactory.class);
        }
        catch (Throwable th) {
            System.out.println("Error calling LoggingFactory.getLogger(MonitorFactory.class)");
            th.printStackTrace();
        }
        MonitorFactory.setupDefaultMonitorFacade();
        System.out.println(MonitorFactory.getStartupMessage());
    }

    private static String getStartupMessage() {
        String version = AgentHelper.getVersion();
        String msg = "\n***************************************************************\n* InfraRED version " + version + "\n" + "*\n";
        msg = LoggingFactory.isLoggingConfigured() ? (LoggingFactory.isDefultLoggingUsed() ? msg + "* Configured default logging system from " + LoggingFactory.getLoggingConfiguration() + ". No debug messages would be logged.\n" : (LoggingFactory.isDebugLoggingEnabled() ? msg + "* Configured logging system from " + LoggingFactory.getLoggingConfiguration() + ".\n" : msg + "* Configured logging system from " + LoggingFactory.getLoggingConfiguration() + ". No debug messages would be logged as -D" + "infrared.debug" + "=true JVM PARAM is not set.\n")) : msg + "* Failed to configure logging system\n";
        msg = msg + "***************************************************************\n";
        return msg;
    }

    private static void setupDefaultMonitorFacade() {
        String applicationName = "default-facade";
        String hostName = AgentHelper.getLocalHostName();
        MonitorConfigImpl defaultConfig = new MonitorConfigImpl(DEFAULT_CONFIG_LOCATION);
        MonitorFacadeImpl facade = new MonitorFacadeImpl(applicationName, hostName, defaultConfig, false);
        defaultFacade = new MultipleEntryGuard(facade);
    }

    static {
        classLoaderToMonitorFacadeMap = new WeakHashMap();
        defaultFacade = null;
        MonitorFactory.init();
    }
}

