/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent;

import net.sf.infrared.agent.MonitorConfig;
import net.sf.infrared.agent.MonitorFacade;
import net.sf.infrared.agent.StatisticsCollector;
import net.sf.infrared.base.model.ExecutionTimer;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class MultipleEntryGuard
implements MonitorFacade {
    private static final Logger log = LoggingFactory.getLogger(MultipleEntryGuard.class);
    private static final long NO_OF_FATAL_ERRORS_TOLERATED = 10L;
    private static final int THRESHOLD = 30;
    private MonitorFacade delegate;
    private int fatalErrors = 0;
    private long methodStartTime = 0L;
    private ThreadLocal callInProgress = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return Boolean.FALSE;
        }
    };

    public MultipleEntryGuard(MonitorFacade delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Delate MonitorFacade cannot be null");
        }
        this.delegate = delegate;
    }

    public StatisticsCollector recordExecutionBegin(ExecutionTimer timer) {
        try {
            return this.delegate.recordExecutionBegin(timer);
        }
        catch (Throwable t) {
            this.handleError();
            log.error("Exception generated from InfraRED", t);
            return null;
        }
    }

    public void recordExecutionEnd(ExecutionTimer timer) {
        try {
            this.delegate.recordExecutionEnd(timer);
        }
        catch (Throwable t) {
            this.handleError();
            log.error("Exception generated from InfraRED", t);
        }
    }

    public void recordExecutionEnd(ExecutionTimer timer, StatisticsCollector collector) {
        try {
            this.delegate.recordExecutionEnd(timer, collector);
        }
        catch (Throwable t) {
            this.handleError();
            log.error("Exception generated from InfraRED", t);
        }
    }

    public boolean isMonitoringEnabled() {
        return this.delegate.isMonitoringEnabled();
    }

    public MonitorConfig getConfiguration() {
        return this.delegate.getConfiguration();
    }

    private boolean isCallInProgress() {
        return (Boolean)this.callInProgress.get() == Boolean.TRUE;
    }

    public String getApplicationName() {
        return this.delegate.getApplicationName();
    }

    public String getInstanceId() {
        return this.delegate.getInstanceId();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    private void startCall() {
        this.callInProgress.set(Boolean.TRUE);
    }

    private void endCall() {
        this.callInProgress.set(Boolean.FALSE);
    }

    private void handleError() {
        ++this.fatalErrors;
        if ((long)this.fatalErrors >= 10L) {
            log.error("Error thresholds crossed, turning off infrared");
            this.delegate.getConfiguration().enableMonitoring(false);
            this.delegate.getConfiguration().enableCallTracing(false);
        }
    }
}

