/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent;

import java.util.Date;
import java.util.Map;
import net.sf.infrared.agent.ChildTimeTracker;
import net.sf.infrared.agent.ChildTimeTrackerImpl;
import net.sf.infrared.agent.ExecutionTimeTracker;
import net.sf.infrared.agent.LayerTimeTracker;
import net.sf.infrared.agent.MonitorConfig;
import net.sf.infrared.agent.TreeBuilder;
import net.sf.infrared.agent.transport.CollectionStrategy;
import net.sf.infrared.base.model.ExecutionTimer;
import net.sf.infrared.base.model.OperationStatistics;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.base.util.Tree;
import net.sf.infrared.org.apache.log4j.Logger;

public class StatisticsCollector {
    private static final Logger log = LoggingFactory.getLogger(StatisticsCollector.class);
    private static final Logger healthLog = LoggingFactory.getLogger("net.sf.infrared.agent.health");
    private MonitorConfig configuration = null;
    private String applicationName = "all applications";
    private String instanceId = "unknown instance";
    private CollectionStrategy collectionStrategy = null;
    private ChildTimeTracker childTracker = new ChildTimeTrackerImpl();
    private LayerTimeTracker layerTracker = new LayerTimeTracker();
    private TreeBuilder treeBuilder = new TreeBuilder();
    private ExecutionTimeTracker executionTracker = new ExecutionTimeTracker();
    private int depth = 0;
    private long startTime = -1L;
    private long endTime = -1L;
    private int numOfExecutionsTracked = 0;
    private int numOfExecutionsIgnored = 0;
    private boolean callTracing;
    private long pruneBelowTime;
    private boolean callInProgress = false;

    public StatisticsCollector(CollectionStrategy collectionStrategy, String applicationName, String instanceId, MonitorConfig configuration) {
        this.collectionStrategy = collectionStrategy;
        this.applicationName = applicationName;
        this.instanceId = instanceId;
        this.configuration = configuration;
        if (log.isDebugEnabled()) {
            log.debug("Created Statistics Collector for application " + applicationName + " on host " + instanceId + " thread " + Thread.currentThread());
        }
        this.callTracing = configuration.isCallTracingEnabled();
        this.pruneBelowTime = configuration.getPruneThreshold();
        this.treeBuilder.setPruneBelowTime(this.pruneBelowTime);
        this.layerTracker.setPruneBelowTime(this.pruneBelowTime);
    }

    StatisticsCollector() {
    }

    public void recordExecutionBegin(ExecutionTimer timer) {
        if (this.callInProgress) {
            return;
        }
        this.callInProgress = true;
        this.begin(timer);
        timer.start();
        this.callInProgress = false;
    }

    void begin(ExecutionTimer timer) {
        this.incrementDepthCount();
        this.childTracker.begin();
        this.layerTracker.enterLayer(timer);
        if (this.isCallTracingEnabled()) {
            this.treeBuilder.begin(timer);
        }
        if (log.isDebugEnabled()) {
            log.debug(this + " - Recording beginining of execution of " + timer.getContext() + " at depth " + this.depth);
        }
    }

    public void recordExecutionEnd(ExecutionTimer timer) {
        if (this.callInProgress) {
            return;
        }
        this.callInProgress = true;
        timer.stop();
        this.end(timer);
        this.callInProgress = false;
    }

    void end(ExecutionTimer timer) {
        if (log.isDebugEnabled()) {
            log.debug(this + " - Recorded end of execution of " + timer.getContext() + " at depth " + this.depth);
        }
        this.setExclusiveTime(timer);
        boolean ok = true;
        if (this.isCallTracingEnabled()) {
            boolean bl = ok = this.treeBuilder.end(timer) && ok;
        }
        if (timer.getInclusiveTime() > this.pruneBelowTime) {
            this.executionTracker.recordExecution(this.layerTracker.getCurrentLayer(), timer);
        } else if (log.isDebugEnabled()) {
            log.debug("Discarded tracking execution of " + timer.getContext() + " because the time (" + timer.getInclusiveTime() + ") <= prune threshold (" + this.pruneBelowTime + ")");
        }
        ok = ok && this.layerTracker.leaveLayer(timer);
        this.childTracker.end();
        boolean bl = ok = ok && this.decrementDepthCount();
        if (!ok) {
            log.error(this + " - Mismatch detected in begin/end calls, " + "dumping stats collected so far");
            this.dumpStatsAndResetTrackers();
        }
    }

    public CollectionStrategy getCollectionStrategy() {
        return this.collectionStrategy;
    }

    public void setCollectionStrategy(CollectionStrategy cs) {
        this.collectionStrategy = cs;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String name) {
        this.applicationName = name;
    }

    public String getHostName() {
        return this.instanceId;
    }

    public void setHostName(String host) {
        this.instanceId = host;
    }

    public MonitorConfig getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MonitorConfig configuration) {
        this.configuration = configuration;
    }

    public String toString() {
        return "StatisticsCollector[" + this.getApplicationName() + " on " + this.getHostName() + ", thread = " + Thread.currentThread() + "]";
    }

    void setExclusiveTime(ExecutionTimer timer) {
        long inclusiveTime;
        long exclusiveTime = inclusiveTime = timer.getInclusiveTime();
        if (inclusiveTime > this.pruneBelowTime) {
            this.childTracker.recordChildExecutionTime(inclusiveTime);
            exclusiveTime = inclusiveTime - this.childTracker.getChildExecutionTime();
            ++this.numOfExecutionsTracked;
        } else {
            ++this.numOfExecutionsIgnored;
        }
        timer.setExclusiveTime(exclusiveTime);
    }

    void incrementDepthCount() {
        if (this.depth == 0) {
            this.pruneBelowTime = this.getConfiguration().getPruneThreshold();
            this.callTracing = this.getConfiguration().isCallTracingEnabled();
            this.treeBuilder.setPruneBelowTime(this.pruneBelowTime);
            this.layerTracker.setPruneBelowTime(this.pruneBelowTime);
            this.startTime = System.currentTimeMillis();
        }
        ++this.depth;
    }

    boolean decrementDepthCount() {
        --this.depth;
        if (this.depth < 0) {
            log.error("Depth count should have been positive, it is now " + this.depth);
            return false;
        }
        if (this.depth == 0) {
            this.endTime = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug(this + " - Reached end of an operation; collecting stats " + "and resetting trackers");
            }
            this.collectStatsAndResetTrackers();
        }
        return true;
    }

    long getPruneBelowTime() {
        return this.pruneBelowTime;
    }

    boolean isCallTracingEnabled() {
        return this.callTracing;
    }

    void collectStatsAndResetTrackers() {
        this.childTracker.reset();
        Map executionTimings = this.executionTracker.reset();
        Map layerTimings = this.layerTracker.reset(false);
        Tree requestTree = null;
        if (this.isCallTracingEnabled()) {
            requestTree = this.treeBuilder.reset();
        }
        OperationStatistics stats = this.createOperationStats(executionTimings, layerTimings, requestTree);
        this.getCollectionStrategy().collect(stats);
        this.logAgentHealth();
        this.endTime = -1L;
        this.startTime = -1L;
        this.numOfExecutionsIgnored = 0;
        this.numOfExecutionsTracked = 0;
    }

    OperationStatistics createOperationStats(Map executionTimings, Map layerTimings, Tree requestTree) {
        OperationStatistics operationStats = new OperationStatistics(this.getApplicationName(), this.getHostName());
        operationStats.setExecutionTimes(executionTimings);
        operationStats.setLayerTimes(layerTimings);
        operationStats.setOperationTree(requestTree);
        operationStats.setApplicationName(this.applicationName);
        operationStats.setInstanceId(this.instanceId);
        operationStats.setStartTime(this.startTime);
        operationStats.setEndTime(this.endTime);
        operationStats.setNumOfExecutions(this.numOfExecutionsTracked, this.numOfExecutionsIgnored);
        return operationStats;
    }

    void logAgentHealth() {
        if (healthLog.isDebugEnabled()) {
            Date startDate = new Date(this.startTime);
            Date endDate = new Date(this.endTime);
            healthLog.debug("Agent collected stats for operation that started at " + startDate + " and ended at " + endDate + ". Tracked " + this.numOfExecutionsTracked + " and ignored " + this.numOfExecutionsIgnored);
        }
    }

    void dumpStatsAndResetTrackers() {
        this.layerTracker.reset(true);
        this.childTracker.reset();
        this.treeBuilder.reset();
        this.executionTracker.reset();
    }
}

