/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent;

import net.sf.infrared.base.model.ExecutionTimer;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.base.util.Tree;
import net.sf.infrared.base.util.TreeNode;
import net.sf.infrared.org.apache.log4j.Logger;

public class TreeBuilder {
    private static final Logger log = LoggingFactory.getLogger(TreeBuilder.class);
    private Tree tree = new Tree();
    private TreeNode currNode = null;
    private long pruneThreshold = -1L;

    public void begin(ExecutionTimer timer) {
        TreeNode node = TreeNode.createTreeNode(timer);
        if (this.currNode == null) {
            this.tree.setRoot(node);
            if (log.isDebugEnabled()) {
                log.debug(this + " - Added node " + timer + " as root");
            }
        } else {
            this.currNode.addChild(node);
        }
        this.currNode = node;
    }

    public boolean end(ExecutionTimer timer) {
        if (this.isCallTraceFaulty(timer)) {
            log.error(this + " - Call trace is faulty");
            return false;
        }
        TreeNode childNode = this.currNode;
        this.currNode = this.currNode.getParent();
        if (timer.getInclusiveTime() <= this.getPruneBelowTime()) {
            this.removeFromCallTrace(childNode);
            if (log.isDebugEnabled()) {
                log.debug("Removed execution " + timer.getContext() + " from tree " + " because the time (" + timer.getInclusiveTime() + ") <= prune threshold (" + this.getPruneBelowTime() + ")");
            }
        }
        return true;
    }

    public Tree reset() {
        if (log.isDebugEnabled()) {
            log.debug(this + " - Resetting tree");
        }
        Tree oldTree = this.tree;
        this.tree = new Tree();
        this.currNode = null;
        return oldTree;
    }

    public String toString() {
        return "TreeBuilder for thread " + Thread.currentThread();
    }

    long getPruneBelowTime() {
        return this.pruneThreshold;
    }

    void setPruneBelowTime(long time) {
        this.pruneThreshold = time;
    }

    private void removeFromCallTrace(TreeNode childNode) {
        if (this.currNode != null) {
            this.currNode.removeChild(childNode);
        }
    }

    private boolean isCallTraceFaulty(ExecutionTimer currentExec) {
        if (this.currNode == null) {
            return true;
        }
        ExecutionTimer expectedExec = (ExecutionTimer)this.currNode.getValue();
        if (currentExec != expectedExec) {
            if (log.isDebugEnabled()) {
                log.debug(this + " - Mismatch on stack for Thread " + Thread.currentThread().getName() + ". Expected " + expectedExec.getContext() + ", encountered " + currentExec.getContext());
            }
            return true;
        }
        return false;
    }
}

