/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent.configmgmt;

import net.sf.infrared.agent.MonitorConfig;
import net.sf.infrared.agent.configmgmt.InfraredPropertiesMBean;

public class InfraredProperties
implements InfraredPropertiesMBean {
    private static final String KEY_JDBC_MONITORING_ENABLED = "jdbc-monitoring-enable";
    private static final String KEY_JDBC_FETCH_STATISTICS_ENABLE = "jdbc-fetch-statistics";
    private MonitorConfig config;

    public InfraredProperties(MonitorConfig config) {
        this.config = config;
    }

    public void setMonitoring(boolean monitoring) {
        this.config.enableMonitoring(monitoring);
    }

    public boolean getMonitoring() {
        return this.config.isMonitoringEnabled();
    }

    public void setCallTraceProfiling(boolean callTraceProfiling) {
        this.config.enableCallTracing(callTraceProfiling);
    }

    public boolean getCallTraceProfiling() {
        return this.config.isCallTracingEnabled();
    }

    public void setJdbcMonitoringEnabled(boolean jdbcMonitoringEnabled) {
        this.config.setProperty(KEY_JDBC_MONITORING_ENABLED, jdbcMonitoringEnabled);
    }

    public boolean getJdbcMonitoringEnabled() {
        return this.config.getProperty(KEY_JDBC_MONITORING_ENABLED, true);
    }

    public void setCollectFetchDataEnabled(boolean collectFetchDataEnabled) {
        this.config.setProperty(KEY_JDBC_FETCH_STATISTICS_ENABLE, collectFetchDataEnabled);
    }

    public boolean getCollectFetchDataEnabled() {
        return this.config.getProperty(KEY_JDBC_FETCH_STATISTICS_ENABLE, true);
    }

    public void setPruneBelowTime(long pruneBelowTime) {
        this.config.setPruneThreshold(pruneBelowTime);
    }

    public long getPruneBelowTime() {
        return this.config.getPruneThreshold();
    }
}

