/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent.setup;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.sf.infrared.agent.MonitorConfig;
import net.sf.infrared.agent.MonitorConfigImpl;
import net.sf.infrared.agent.MonitorFacade;
import net.sf.infrared.agent.MonitorFacadeImpl;
import net.sf.infrared.agent.MonitorFactory;
import net.sf.infrared.agent.MultipleEntryGuard;
import net.sf.infrared.agent.configmgmt.InfraredProperties;
import net.sf.infrared.base.configmgmt.AbstractMBeanServerFactory;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class InfraREDLifeCycleListener {
    private static final Logger log = LoggingFactory.getLogger(InfraREDLifeCycleListener.class);
    private static final String KEY_MBEAN_SERVER_PROVIDER = "mbean-server-provider";
    private MBeanServer mbeanServer = null;
    private ObjectName propertiesObjectName;
    private MonitorFacade facade = null;

    public void initialized(String applicationName, String instanceId, String configProvider) {
        MonitorConfigImpl config = new MonitorConfigImpl(configProvider);
        this.facade = new MonitorFacadeImpl(applicationName, instanceId, config, true);
        this.facade = new MultipleEntryGuard(this.facade);
        MonitorFactory.registerFacadeImpl(this.facade);
        if (log.isDebugEnabled()) {
            log.debug("Initializing application : " + applicationName + " InstanceId : " + instanceId);
        }
        this.setMBeanServer(config, applicationName, instanceId);
        this.registerMBeans(config);
    }

    public void destroyed(String applicationName) {
        this.unregisterMBeans();
        MonitorFacade facade = MonitorFactory.unregisterFacadeImpl();
        if (facade != null) {
            facade.destroy();
        }
        if (log.isDebugEnabled()) {
            log.debug("Destroying application " + applicationName);
        }
    }

    public void registerMBeans(MonitorConfig config) {
        if (this.mbeanServer != null) {
            InfraredProperties infraredProperties = new InfraredProperties(config);
            try {
                String objectName = "InfraredProperties:name=Infrared Properties,type=InfraredPropertiesMBean";
                this.propertiesObjectName = new ObjectName(objectName);
                this.mbeanServer.registerMBean(infraredProperties, this.propertiesObjectName);
                log.debug("The MBean has been successfully registered !");
            }
            catch (MalformedObjectNameException e) {
                log.error("The MBean Object name is Malformed", e);
            }
            catch (InstanceAlreadyExistsException e) {
                log.error("The MBean instance already exists", e);
            }
            catch (MBeanRegistrationException e) {
                log.error("The MBean Registration failed", e);
            }
            catch (NotCompliantMBeanException e) {
                log.error("The MBean is not Compliant &  Registration failed", e);
            }
        }
    }

    public void unregisterMBeans() {
        if (this.mbeanServer == null) {
            return;
        }
        try {
            this.mbeanServer.unregisterMBean(this.propertiesObjectName);
        }
        catch (MBeanRegistrationException e) {
            log.error("Unable to unregister the MBean", e);
        }
        catch (InstanceNotFoundException e) {
            log.error("The MBean instance is not registered in the MBeanServer", e);
        }
    }

    public MonitorFacade getFacade() {
        return this.facade;
    }

    private void setMBeanServer(MonitorConfig config, String appName, String instanceId) {
        String mbeanServerClass = config.getProperty(KEY_MBEAN_SERVER_PROVIDER, null);
        if (mbeanServerClass == null) {
            log.warn("No MBean Server Class set for application " + appName + ", instance " + instanceId);
            return;
        }
        try {
            AbstractMBeanServerFactory mbeanServerProvider = (AbstractMBeanServerFactory)Class.forName(mbeanServerClass).newInstance();
            this.mbeanServer = mbeanServerProvider.getMBeanServer();
        }
        catch (Exception e) {
            log.error("Unable to load MBeanServer provider", e);
        }
    }
}

