/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent.setup;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.sf.infrared.agent.setup.InfraREDLifeCycleListener;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class InfraREDServletContextListener
implements ServletContextListener {
    public static final String KEY_CONFIGURATIONPROVIDER = "net.sf.infrared.configurationprovider";
    private static final Logger log = LoggingFactory.getLogger(InfraREDServletContextListener.class);
    private InfraREDLifeCycleListener lifeCycleListener = new InfraREDLifeCycleListener();

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        this.initialized(context);
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.destroyed(event.getServletContext());
    }

    public void initialized(ServletContext context) {
        String appName;
        String configProvider = (String)context.getAttribute(KEY_CONFIGURATIONPROVIDER);
        if (configProvider == null) {
            configProvider = "infrared-agent.properties";
        }
        if ((appName = context.getServletContextName()) == null) {
            appName = "unknown";
            log.info("Application name is not set in the war");
        }
        this.getLifeCycleListener().initialized(appName, this.getInstanceId(), configProvider);
    }

    public void destroyed(ServletContext context) {
        this.getLifeCycleListener().destroyed(context.getServletContextName());
    }

    public String getInstanceId() {
        String instanceId = "unknown";
        try {
            instanceId = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error(e);
        }
        return instanceId;
    }

    InfraREDLifeCycleListener getLifeCycleListener() {
        return this.lifeCycleListener;
    }
}

