/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent.transport.impl;

import net.sf.infrared.agent.transport.Aggregator;
import net.sf.infrared.agent.transport.Forwarder;
import net.sf.infrared.base.model.ApplicationStatistics;
import net.sf.infrared.base.model.OperationStatistics;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class BufferedAggregator
implements Aggregator {
    private static final Logger log = LoggingFactory.getLogger(BufferedAggregator.class);
    private Forwarder forwarder;
    private ApplicationStatistics bufferStatistics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate(OperationStatistics stats) {
        log.info("BufferedAggregator.aggregate");
        BufferedAggregator bufferedAggregator = this;
        synchronized (bufferedAggregator) {
            if (this.bufferStatistics == null) {
                this.bufferStatistics = new ApplicationStatistics(stats.getApplicationName(), stats.getInstanceId());
                log.info("Create new statistics object");
            }
            this.bufferStatistics.merge(stats);
            log.info("Merged statistics");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ApplicationStatistics statsToFlush = null;
        BufferedAggregator bufferedAggregator = this;
        synchronized (bufferedAggregator) {
            if (this.bufferStatistics == null) {
                if (this.bufferStatistics == null && log.isDebugEnabled()) {
                    log.debug("No stats to send to collector; ignoring flush");
                }
                return;
            }
            statsToFlush = this.bufferStatistics;
            this.bufferStatistics = null;
        }
        if (this.forwarder != null) {
            if (statsToFlush != null) {
                this.forwarder.forward(statsToFlush);
                statsToFlush.reset();
            }
        } else {
            log.error("Forwarder not initialized");
        }
    }

    public void setForwarder(Forwarder forwarder) {
        this.forwarder = forwarder;
    }

    public void shutdown() {
    }
}

