/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent.transport.impl;

import net.sf.infrared.agent.MonitorConfig;
import net.sf.infrared.agent.transport.Aggregator;
import net.sf.infrared.agent.transport.CollectionStrategy;
import net.sf.infrared.agent.transport.Forwarder;
import net.sf.infrared.agent.transport.impl.BufferedAggregator;
import net.sf.infrared.agent.transport.impl.PeriodicFlushPolicy;
import net.sf.infrared.agent.transport.impl.PooledAggregator;
import net.sf.infrared.agent.transport.impl.SocketForwarder;
import net.sf.infrared.base.model.OperationStatistics;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class CentralizedCollectionStrategy
implements CollectionStrategy {
    private static final String KEY_FLUSH_FREQUENCY = "collection-strategy.ccs.flush-frequency";
    private static final String KEY_POOL = "collection-strategy.ccs.pool";
    private static final String KEY_POOL_MAX_THREADS = "collection-strategy.ccs.pool.maxThreads";
    private static final String KEY_POOL_BUFFER_LENGTH = "collection-strategy.ccs.pool.buffer-length";
    private static final String KEY_REMOTE_HOST = "collection-strategy.ccs.remotehost";
    private static final String KEY_REMOTE_PORT = "collection-strategy.ccs.port";
    private static final String DEFAULT_REMOTE_HOST = "localhost";
    private static final int DEFAULT_REMOTE_PORT = 7777;
    private static final int DEFAULT_POOL_MAX_THREADS = 1;
    private static final int DEFAULT_POOL_BUFFER_LENGTH = 100;
    private static final Logger log = LoggingFactory.getLogger(CentralizedCollectionStrategy.class);
    private Aggregator aggregator = null;
    private Forwarder forwarder = null;
    private PeriodicFlushPolicy flushPolicy = null;
    private boolean suspended = false;

    public boolean init(MonitorConfig configuration) {
        String hostName = configuration.getProperty(KEY_REMOTE_HOST, DEFAULT_REMOTE_HOST);
        int portNo = configuration.getProperty(KEY_REMOTE_PORT, 7777);
        this.forwarder = new SocketForwarder(hostName, portNo);
        if (configuration.getProperty(KEY_POOL, true)) {
            log.debug("Using PooledAggregator for CentralCollectionStrategy");
            int length = configuration.getProperty(KEY_POOL_BUFFER_LENGTH, 100);
            int maxThreads = configuration.getProperty(KEY_POOL_MAX_THREADS, 1);
            this.aggregator = new PooledAggregator(new BufferedAggregator(), length, maxThreads);
        } else {
            log.debug("Using BufferedAggregator (not pooled) for CentralCollectionStrategy");
            this.aggregator = new BufferedAggregator();
        }
        this.aggregator.setForwarder(this.forwarder);
        this.flushPolicy = new PeriodicFlushPolicy();
        long flushFrequency = configuration.getProperty(KEY_FLUSH_FREQUENCY, 30000L);
        this.flushPolicy.setFrequency(flushFrequency);
        this.flushPolicy.setAggregator(this.aggregator);
        this.forwarder.init(false);
        if (log.isDebugEnabled()) {
            log.debug("Initialized CentralCollectionStrategy remote host = " + hostName + " remote port = " + portNo);
        }
        return this.flushPolicy.activate();
    }

    public boolean collect(OperationStatistics stats) {
        if (!this.suspended) {
            this.aggregator.aggregate(stats);
            return true;
        }
        log.info("Ignoring - as stats collection suspended");
        return false;
    }

    public void suspend() {
        this.suspended = true;
        this.forwarder.suspend();
    }

    public void resume() {
        this.suspended = false;
        this.forwarder.resume();
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public boolean destroy() {
        this.flushPolicy.shutDown();
        this.aggregator.setForwarder(null);
        this.aggregator.shutdown();
        this.forwarder.destroy();
        this.aggregator = null;
        this.forwarder = null;
        return false;
    }
}

