/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent.transport.impl;

import net.sf.infrared.agent.MonitorConfig;
import net.sf.infrared.agent.transport.Aggregator;
import net.sf.infrared.agent.transport.CollectionStrategy;
import net.sf.infrared.agent.transport.FlushPolicy;
import net.sf.infrared.agent.transport.Forwarder;
import net.sf.infrared.agent.transport.impl.BufferedAggregator;
import net.sf.infrared.agent.transport.impl.LoggingForwarder;
import net.sf.infrared.agent.transport.impl.PeriodicFlushPolicy;
import net.sf.infrared.agent.transport.impl.PooledAggregator;
import net.sf.infrared.base.model.OperationStatistics;

public class LoggingCollectionStrategy
implements CollectionStrategy {
    private Aggregator aggregator = null;
    private Forwarder forwarder = null;
    private FlushPolicy flushPolicy = null;

    public boolean init(MonitorConfig configuration) {
        this.forwarder = new LoggingForwarder();
        this.aggregator = new PooledAggregator(new BufferedAggregator(), 100, 1);
        this.aggregator.setForwarder(new LoggingForwarder());
        this.flushPolicy = new PeriodicFlushPolicy();
        this.flushPolicy.setAggregator(this.aggregator);
        this.forwarder.init(false);
        return this.flushPolicy.activate();
    }

    public boolean collect(OperationStatistics stats) {
        this.aggregator.aggregate(stats);
        return true;
    }

    public void suspend() {
    }

    public void resume() {
    }

    public boolean destroy() {
        this.flushPolicy.shutDown();
        this.aggregator.setForwarder(null);
        this.forwarder.destroy();
        this.aggregator = null;
        this.forwarder = null;
        return false;
    }
}

