/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent.transport.impl;

import java.util.Timer;
import java.util.TimerTask;
import net.sf.infrared.agent.transport.Aggregator;
import net.sf.infrared.agent.transport.FlushPolicy;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class PeriodicFlushPolicy
implements FlushPolicy {
    public static final long DEFAULT_FREQUENCY = 30000L;
    private static Logger log = LoggingFactory.getLogger(PeriodicFlushPolicy.class);
    private Aggregator aggregator;
    private long frequency = 30000L;
    private Timer timer = null;

    public boolean activate() {
        if (this.isActive()) {
            return false;
        }
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (PeriodicFlushPolicy.this.aggregator != null) {
                    PeriodicFlushPolicy.this.aggregator.flush();
                }
            }
        }, 0L, this.frequency);
        return true;
    }

    public boolean shutDown() {
        if (!this.isActive()) {
            return false;
        }
        this.timer.cancel();
        this.timer = null;
        return true;
    }

    public void setAggregator(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    public boolean isActive() {
        return this.timer != null;
    }

    public void setFrequency(long time) {
        if (time <= 0L) {
            log.error("Attempt to set frequency to " + time + "ms ignored. " + "Flush frequency should be greater than zero ms");
            return;
        }
        this.frequency = time;
        if (log.isDebugEnabled()) {
            log.debug("Flush frequency set to " + time + " ms");
        }
    }

    public long getFrequency() {
        return this.frequency;
    }
}

