/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent.transport.impl;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import net.sf.infrared.agent.transport.Aggregator;
import net.sf.infrared.agent.transport.Forwarder;
import net.sf.infrared.base.model.OperationStatistics;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class PooledAggregator
implements Aggregator {
    private static final Logger log = LoggingFactory.getLogger(PooledAggregator.class);
    private PooledExecutor executor;
    private Aggregator aggregator;

    public PooledAggregator(Aggregator aggregator, int bufferLength, int maxThreads) {
        this.aggregator = aggregator;
        this.executor = new PooledExecutor((Channel)new BoundedBuffer(bufferLength), maxThreads);
        this.executor.setKeepAliveTime(300000L);
        this.executor.discardOldestWhenBlocked();
    }

    public void aggregate(final OperationStatistics stats) {
        try {
            this.executor.execute(new Runnable(){

                public void run() {
                    PooledAggregator.this.aggregator.aggregate(stats);
                }
            });
            if (log.isDebugEnabled()) {
                log.debug("Scheduled " + stats + " for merging");
            }
        }
        catch (InterruptedException e) {
            log.error("Error in aggregate, ignoring", e);
        }
    }

    public void flush() {
        this.aggregator.flush();
    }

    public void setForwarder(Forwarder forwarder) {
        this.aggregator.setForwarder(forwarder);
    }

    public void shutdown() {
        this.executor.shutdownNow();
        this.aggregator.shutdown();
    }
}

